/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.processors;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class WaterlogWhenReplacingWaterProcessor
extends StructureProcessor {
    public static final MapCodec<WaterlogWhenReplacingWaterProcessor> CODEC = MapCodec.unit(WaterlogWhenReplacingWaterProcessor::new);

    private WaterlogWhenReplacingWaterProcessor() {
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos pos, BlockPos pos2, StructureTemplate.StructureBlockInfo infoIn1, StructureTemplate.StructureBlockInfo infoIn2, StructurePlaceSettings settings) {
        if (infoIn2.state().hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            WorldGenRegion worldGenRegion;
            if (levelReader instanceof WorldGenRegion && !(worldGenRegion = (WorldGenRegion)levelReader).getCenter().equals((Object)new ChunkPos(infoIn2.pos()))) {
                return infoIn2;
            }
            BlockState blockState = levelReader.getChunk(infoIn2.pos()).getBlockState(infoIn2.pos());
            boolean isWater = blockState.getFluidState().is(FluidTags.WATER);
            if (isWater) {
                ChunkAccess chunk = levelReader.getChunk(infoIn2.pos());
                int minY = chunk.getMinBuildHeight();
                int maxY = chunk.getMaxBuildHeight();
                int currentY = infoIn2.pos().getY();
                if (currentY >= minY && currentY <= maxY) {
                    ((LevelAccessor)levelReader).scheduleTick(infoIn2.pos(), infoIn2.state().getBlock(), 0);
                }
            }
            return new StructureTemplate.StructureBlockInfo(infoIn2.pos(), (BlockState)infoIn2.state().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(isWater)), infoIn2.nbt());
        }
        return infoIn2;
    }

    protected StructureProcessorType<?> getType() {
        return RSProcessors.WATERLOGGING_WHEN_REPLACING_WATER_PROCESSOR.get();
    }
}

