/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CeilingVinePostProcessor
extends StructureProcessor {
    public static final MapCodec<CeilingVinePostProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("probability").stable().forGetter(ceilingVinePostProcessor -> Float.valueOf(ceilingVinePostProcessor.probability)), (App)BlockState.CODEC.fieldOf("blockstate").forGetter(ceilingVinePostProcessor -> ceilingVinePostProcessor.blockState)).apply((Applicative)instance, instance.stable(CeilingVinePostProcessor::new)));
    private final float probability;
    private final BlockState blockState;

    public CeilingVinePostProcessor(float probability, BlockState blockState) {
        this.probability = probability;
        this.blockState = blockState;
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader worldView, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings structurePlacementData) {
        if (structureBlockInfoWorld.state().isAir()) {
            WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
            random.setSeed(structureBlockInfoWorld.pos().asLong() * (long)structureBlockInfoWorld.pos().getY());
            ChunkAccess centerChunk = worldView.getChunk(structureBlockInfoWorld.pos());
            BlockState centerState = centerChunk.getBlockState(structureBlockInfoWorld.pos());
            BlockPos abovePos = structureBlockInfoWorld.pos().above();
            BlockState aboveState = centerChunk.getBlockState(abovePos);
            if (random.nextFloat() < this.probability && centerState.isAir() && Block.isFaceFull((VoxelShape)aboveState.getCollisionShape((BlockGetter)worldView, abovePos), (Direction)Direction.DOWN)) {
                BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
                List shuffledDirectionList = Direction.Plane.HORIZONTAL.stream().collect(Collectors.toList());
                Collections.shuffle(shuffledDirectionList);
                block0: for (Direction facing : shuffledDirectionList) {
                    mutable.set((Vec3i)structureBlockInfoWorld.pos()).move(facing);
                    BlockState worldState = worldView.getChunk((BlockPos)mutable).getBlockState((BlockPos)mutable);
                    if (worldState.canOcclude()) continue;
                    worldView.getChunk((BlockPos)mutable).setBlockState((BlockPos)mutable, this.blockState, false);
                    BlockState vineBlock = (BlockState)((BlockState)Blocks.VINE.defaultBlockState().setValue((Property)VineBlock.getPropertyForFace((Direction)facing), (Comparable)Boolean.valueOf(true))).setValue((Property)VineBlock.UP, (Comparable)Boolean.valueOf(true));
                    mutable.move(facing.getOpposite());
                    centerChunk.setBlockState((BlockPos)mutable, vineBlock, false);
                    vineBlock = (BlockState)vineBlock.setValue((Property)VineBlock.UP, (Comparable)Boolean.valueOf(false));
                    for (int depth = random.nextInt(4); depth < 3; ++depth) {
                        mutable.move(Direction.DOWN);
                        if (!centerChunk.getBlockState((BlockPos)mutable).isAir()) break block0;
                        centerChunk.setBlockState((BlockPos)mutable, vineBlock, false);
                    }
                }
            }
        }
        return structureBlockInfoWorld;
    }

    protected StructureProcessorType<?> getType() {
        return RSProcessors.CEILING_VINE_POST_PROCESSOR.get();
    }
}

