/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.features.configs.GenericMobConfig;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class Skeletons
extends Feature<GenericMobConfig> {
    public Skeletons() {
        super(GenericMobConfig.CODEC);
    }

    public boolean place(FeaturePlaceContext<GenericMobConfig> context) {
        Skeleton skeletonEntity = (Skeleton)EntityType.SKELETON.create((Level)context.level().getLevel());
        skeletonEntity.finalizeSpawn((ServerLevelAccessor)context.level(), context.level().getCurrentDifficultyAt(context.origin()), MobSpawnType.STRUCTURE, null);
        ((GenericMobConfig)context.config()).heldItem.ifPresent(item -> {
            ItemStack heldItem = new ItemStack((ItemLike)item);
            skeletonEntity.setItemInHand(InteractionHand.MAIN_HAND, GeneralUtils.enchantRandomly(context.level().registryAccess(), context.random(), heldItem, 0.333f));
            skeletonEntity.setLeftHanded(context.random().nextFloat() < 0.05f);
        });
        ((GenericMobConfig)context.config()).helmet.ifPresent(item -> skeletonEntity.setItemSlot(EquipmentSlot.HEAD, GeneralUtils.enchantRandomly(context.level().registryAccess(), context.random(), item.getDefaultInstance(), 0.075f)));
        ((GenericMobConfig)context.config()).chestplate.ifPresent(item -> skeletonEntity.setItemSlot(EquipmentSlot.CHEST, GeneralUtils.enchantRandomly(context.level().registryAccess(), context.random(), item.getDefaultInstance(), 0.075f)));
        ((GenericMobConfig)context.config()).leggings.ifPresent(item -> skeletonEntity.setItemSlot(EquipmentSlot.LEGS, GeneralUtils.enchantRandomly(context.level().registryAccess(), context.random(), item.getDefaultInstance(), 0.075f)));
        ((GenericMobConfig)context.config()).boots.ifPresent(item -> skeletonEntity.setItemSlot(EquipmentSlot.FEET, GeneralUtils.enchantRandomly(context.level().registryAccess(), context.random(), item.getDefaultInstance(), 0.075f)));
        skeletonEntity.setPersistenceRequired();
        skeletonEntity.moveTo((double)context.origin().getX() + 0.5, (double)context.origin().getY(), (double)context.origin().getZ() + 0.5, 0.0f, 0.0f);
        skeletonEntity.setHealth((float)((GenericMobConfig)context.config()).health);
        skeletonEntity.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)((GenericMobConfig)context.config()).health);
        skeletonEntity.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue((double)((GenericMobConfig)context.config()).speedModifier);
        context.level().addFreshEntityWithPassengers((Entity)skeletonEntity);
        return true;
    }
}

