/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc.pooladditions;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.events.lifecycle.ServerGoingToStartEvent;
import com.telepathicgrunt.repurposedstructures.mixins.structures.StructurePoolAccessor;
import com.telepathicgrunt.repurposedstructures.modinit.RSConditionsRegistry;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public final class PoolAdditionMergerManager
extends SimpleJsonResourceReloadListener {
    public static final PoolAdditionMergerManager POOL_ADDITIONS_MERGER_MANAGER = new PoolAdditionMergerManager();
    private static Map<ResourceLocation, JsonElement> cachedMap = null;

    public PoolAdditionMergerManager() {
        super(RepurposedStructures.GSON, "rs_pool_additions");
    }

    protected void apply(Map<ResourceLocation, JsonElement> loader, ResourceManager manager, ProfilerFiller profiler) {
        cachedMap = loader;
    }

    public static void mergeAdditionPools(ServerGoingToStartEvent event) {
        if (cachedMap != null) {
            PoolAdditionMergerManager.parsePoolsAndBeginMerger(cachedMap, event.getServer().registryAccess(), event.getServer().getResourceManager());
            cachedMap = null;
        }
    }

    private static void parsePoolsAndBeginMerger(Map<ResourceLocation, JsonElement> poolAdditionJSON, RegistryAccess.Frozen frozen, ResourceManager manager) {
        Registry poolRegistry = frozen.registryOrThrow(Registries.TEMPLATE_POOL);
        RegistryOps customRegistryOps = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)frozen);
        for (Map.Entry<ResourceLocation, JsonElement> entry : poolAdditionJSON.entrySet()) {
            ResourceLocation targetPool = ResourceLocation.parse((String)entry.getValue().getAsJsonObject().get("target_pool").getAsString());
            if (poolRegistry.get(targetPool) == null) continue;
            try {
                AdditionalStructureTemplatePool.DIRECT_CODEC.parse((DynamicOps)customRegistryOps, (Object)entry.getValue()).resultOrPartial(messageString -> PoolAdditionMergerManager.logBadData((ResourceLocation)entry.getKey(), messageString)).ifPresent(validPool -> PoolAdditionMergerManager.mergeIntoExistingPool(validPool, (StructureTemplatePool)poolRegistry.get(targetPool), manager));
            }
            catch (Exception e) {
                RepurposedStructures.LOGGER.error("\nRepurposed Structures: Pool Addition json failed to be parsed.\nThis is usually due to using a mod compat datapack without the other mod being on.\nFile failed to be resolved: %s\nTarget pool: %s\nRegistry being used: %s\nError message is: %s".formatted(entry.getKey(), targetPool, poolRegistry, e.getMessage()).indent(1));
            }
        }
    }

    private static void mergeIntoExistingPool(AdditionalStructureTemplatePool feedingPool, StructureTemplatePool gluttonyPool, ResourceManager manager) {
        ObjectArrayList elements = new ObjectArrayList(((StructurePoolAccessor)gluttonyPool).repurposedstructures_getTemplates());
        ArrayList<Pair<StructurePoolElement, Integer>> elementCounts = new ArrayList<Pair<StructurePoolElement, Integer>>(((StructurePoolAccessor)gluttonyPool).repurposedstructures_getRawTemplates());
        elements.addAll(((StructurePoolAccessor)((Object)feedingPool)).repurposedstructures_getTemplates());
        elementCounts.addAll(((StructurePoolAccessor)((Object)feedingPool)).repurposedstructures_getRawTemplates());
        ((StructurePoolAccessor)gluttonyPool).repurposedstructures_setTemplates((ObjectArrayList<StructurePoolElement>)elements);
        ((StructurePoolAccessor)gluttonyPool).repurposedstructures_setRawTemplates(elementCounts);
    }

    private static void logBadData(ResourceLocation poolPath, String messageString) {
        RepurposedStructures.LOGGER.error("(Repurposed Structures POOL MERGER) Failed to parse {} additions file. Error is: {}", (Object)poolPath, (Object)messageString);
    }

    private static class AdditionalStructureTemplatePool
    extends StructureTemplatePool {
        private static final Codec<ExpandedPoolEntry> EXPANDED_POOL_ENTRY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StructurePoolElement.CODEC.fieldOf("element").forGetter(ExpandedPoolEntry::poolElement), (App)Codec.intRange((int)1, (int)5000).fieldOf("weight").forGetter(ExpandedPoolEntry::weight), (App)ResourceLocation.CODEC.optionalFieldOf("condition").forGetter(ExpandedPoolEntry::condition)).apply((Applicative)instance, ExpandedPoolEntry::new));
        public static final Codec<AdditionalStructureTemplatePool> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("target_pool").forGetter(structureTemplatePool -> structureTemplatePool.targetPool), (App)Codec.lazyInitialized(() -> StructurePoolAccessor.getCODEC_REFERENCE().getValue()).fieldOf("fallback").forGetter(StructureTemplatePool::getFallback), (App)EXPANDED_POOL_ENTRY_CODEC.listOf().fieldOf("elements").forGetter(structureTemplatePool -> structureTemplatePool.rawTemplatesWithConditions)).apply((Applicative)instance, AdditionalStructureTemplatePool::new));
        protected final List<ExpandedPoolEntry> rawTemplatesWithConditions;
        protected final ResourceLocation targetPool;

        public AdditionalStructureTemplatePool(ResourceLocation targetPool, Holder<StructureTemplatePool> fallback, List<ExpandedPoolEntry> rawTemplatesWithConditions) {
            super(fallback, rawTemplatesWithConditions.stream().filter(triple -> {
                if (triple.condition().isPresent()) {
                    Supplier<Boolean> supplier = RSConditionsRegistry.RS_JSON_CONDITIONS_REGISTRY.lookup().get(triple.condition.get());
                    if (supplier != null) {
                        return supplier.get();
                    }
                    RepurposedStructures.LOGGER.error("Repurposed Structures Error: Found {} entry has a condition that does not exist. Extra info: {}", (Object)targetPool, (Object)fallback);
                }
                return true;
            }).map(triple -> Pair.of((Object)triple.poolElement(), (Object)triple.weight())).collect(Collectors.toList()));
            this.rawTemplatesWithConditions = rawTemplatesWithConditions;
            this.targetPool = targetPool;
        }

        public record ExpandedPoolEntry(StructurePoolElement poolElement, Integer weight, Optional<ResourceLocation> condition) {
        }
    }
}

