/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc.neoforge.lootmanager;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class DetectRSLootTables
implements LootItemCondition {
    public static final MapCodec<DetectRSLootTables> CODEC = RecordCodecBuilder.mapCodec(configInstance -> configInstance.group((App)ResourceLocation.CODEC.listOf().fieldOf("blacklisted_loot_tables").xmap(HashSet::new, ArrayList::new).forGetter(config -> config.blacklistedLootTableIds)).apply((Applicative)configInstance, DetectRSLootTables::new));
    public static final LootItemConditionType DETECT_RS_LOOT_TABLES = new LootItemConditionType(CODEC);
    private final HashSet<ResourceLocation> blacklistedLootTableIds;

    private DetectRSLootTables(HashSet<ResourceLocation> blacklistedLootTableIds) {
        this.blacklistedLootTableIds = blacklistedLootTableIds;
    }

    public LootItemConditionType getType() {
        return DETECT_RS_LOOT_TABLES;
    }

    public boolean test(LootContext lootContext) {
        ResourceLocation lootTableID = lootContext.getQueriedLootTableId();
        return lootTableID.getNamespace().equals("repurposed_structures") && !this.blacklistedLootTableIds.contains(lootTableID);
    }
}

