/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.compat.crafttweaker;

import com.blakebr0.cucumber.crafting.ingredient.IngredientWithCount;
import com.blakebr0.mysticalagriculture.api.crafting.IEnchanterRecipe;
import com.blakebr0.mysticalagriculture.crafting.recipe.EnchanterRecipe;
import com.blakebr0.mysticalagriculture.init.ModRecipeTypes;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.platform.services.IRegistryHelper;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.mysticalagriculture.EnchanterCrafting")
@ZenRegister
public final class EnchanterCrafting
implements IRecipeManager<IEnchanterRecipe>,
IRegistryHelper {
    public RecipeType<IEnchanterRecipe> getRecipeType() {
        return (RecipeType)ModRecipeTypes.ENCHANTER.get();
    }

    @ZenCodeType.Method
    public void addRecipe(String name, String enchantmentID, IItemStack[] inputs) {
        ResourceLocation id = CraftTweakerConstants.rl((String)this.fixRecipeName(name));
        Holder.Reference enchantment = (Holder.Reference)this.registryOrThrow(Registries.ENCHANTMENT).getHolder(ResourceLocation.parse((String)enchantmentID)).orElseThrow(() -> new RuntimeException("Could not find enchantment " + enchantmentID));
        EnchanterRecipe recipe = new EnchanterRecipe(EnchanterCrafting.toIngredientsList(inputs), (Holder<Enchantment>)enchantment);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, new RecipeHolder(id, (Recipe)recipe)));
    }

    @ZenCodeType.Method
    public void removeByEnchantment(String enchantmentID) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipe((IRecipeManager)this, recipe -> {
            ResourceKey enchantment = ((IEnchanterRecipe)recipe.value()).getEnchantment().getKey();
            return enchantment != null && Objects.equals(enchantment.location(), ResourceLocation.parse((String)enchantmentID));
        }));
    }

    private static NonNullList<IngredientWithCount> toIngredientsList(IItemStack ... istacks) {
        NonNullList ingredients = NonNullList.withSize((int)2, (Object)IngredientWithCount.EMPTY);
        for (int i = 0; i < istacks.length; ++i) {
            IItemStack stack = istacks[i];
            ingredients.set(i, (Object)new IngredientWithCount((Ingredient.Value)new Ingredient.ItemValue(stack.getInternal()), stack.amount()));
        }
        return ingredients;
    }
}

