/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.event.loot;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class CopperBlockLootModifier
extends LootModifier {
    public static final Supplier<MapCodec<CopperBlockLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> CopperBlockLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)ItemStack.CODEC.fieldOf("addition").forGetter(m -> m.addition), (App)Codec.INT.fieldOf("count").forGetter(m -> m.count))).apply((Applicative)inst, CopperBlockLootModifier::new)));
    private final ItemStack addition;
    private final int count;

    protected CopperBlockLootModifier(LootItemCondition[] conditionsIn, ItemStack addition, Integer count) {
        super(conditionsIn);
        this.addition = addition;
        this.count = count;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Item item;
        if (context.getRandom().nextBoolean() && (item = this.addition.getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.getBlock();
            for (int i = 0; i < context.getRandom().nextInt(5); ++i) {
                block = WeatheringCopper.getNext((Block)block).orElse(block);
            }
            ItemStack loot = new ItemStack((ItemLike)block.asItem(), this.count);
            generatedLoot.add((Object)loot);
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return (MapCodec)CODEC.get();
    }
}

