/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.common.entity;

import cy.jdkdigital.everythingcopper.common.entity.IWeatheringEntity;
import cy.jdkdigital.everythingcopper.util.WeatheringUtils;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;

public class CopperGolem
extends IronGolem
implements IWeatheringEntity {
    private static BlockPattern patternBase;
    private static BlockPattern patternFull;

    public CopperGolem(EntityType<? extends IronGolem> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public SynchedEntityData getSyncData() {
        return super.getEntityData();
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_WEATHER_STATE, (Object)WeatheringCopper.WeatherState.UNAFFECTED.name());
        pBuilder.define(DATA_WAXED, (Object)false);
    }

    protected Component getTypeName() {
        String id = (this.isWaxed() ? "waxed_" : "") + this.getAge().name().toLowerCase() + "_copper_golem";
        return Component.translatable((String)this.getType().getDescriptionId().replace("copper_golem", id));
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(Items.COPPER_INGOT)) {
            float f = this.getHealth();
            this.heal(25.0f);
            if (this.getHealth() == f) {
                return InteractionResult.PASS;
            }
            float f1 = 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f;
            this.playSound(SoundEvents.IRON_GOLEM_REPAIR, 1.0f, f1);
            if (!player.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return InteractionResult.PASS;
    }

    public void tick() {
        if (this.tickCount % 369 == 0 && this.canAge() && this.level().random.nextFloat() < 0.005688889f) {
            this.setAge(WeatheringUtils.nextState(this.getAge()));
        }
        super.tick();
    }

    public float getSpeed() {
        return super.getSpeed() * this.speedModifier();
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.saveWeatheredState(tag);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.loadWeatheredState(tag);
    }

    public static boolean canSpawnGolem(LevelReader level, BlockPos pos) {
        return CopperGolem.getOrCreateCopperGolemBase().find(level, pos) != null;
    }

    private static BlockPattern getOrCreateCopperGolemBase() {
        if (patternBase == null) {
            patternBase = BlockPatternBuilder.start().aisle(new String[]{"~ ~", "###", "~#~"}).where('#', BlockInWorld.hasState(state -> state != null && (state.is(Blocks.COPPER_BLOCK) || state.is(Blocks.EXPOSED_COPPER) || state.is(Blocks.WEATHERED_COPPER) || state.is(Blocks.OXIDIZED_COPPER) || state.is(Blocks.WAXED_COPPER_BLOCK) || state.is(Blocks.WAXED_EXPOSED_COPPER) || state.is(Blocks.WAXED_WEATHERED_COPPER) || state.is(Blocks.WAXED_OXIDIZED_COPPER)))).where('~', state -> state.getState().isAir()).build();
        }
        return patternBase;
    }

    public static BlockPattern getOrCreateCopperGolemFull() {
        if (patternFull == null) {
            patternFull = BlockPatternBuilder.start().aisle(new String[]{"~^~", "###", "~#~"}).where('^', BlockInWorld.hasState((Predicate)CarvedPumpkinBlock.PUMPKINS_PREDICATE)).where('#', BlockInWorld.hasState(state -> state != null && (state.is(Blocks.COPPER_BLOCK) || state.is(Blocks.EXPOSED_COPPER) || state.is(Blocks.WEATHERED_COPPER) || state.is(Blocks.OXIDIZED_COPPER) || state.is(Blocks.WAXED_COPPER_BLOCK) || state.is(Blocks.WAXED_EXPOSED_COPPER) || state.is(Blocks.WAXED_WEATHERED_COPPER) || state.is(Blocks.WAXED_OXIDIZED_COPPER)))).where('~', block -> block.getState().isAir()).build();
        }
        return patternFull;
    }
}

