/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui;

import java.util.List;
import java.util.stream.Collectors;
import mcjty.lib.client.GuiTools;
import mcjty.lib.gui.GuiSideWindow;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.gui.Window;
import mcjty.lib.varia.ComponentFactory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;

public abstract class GuiItemScreen
extends Screen {
    protected Window window;
    protected int xSize;
    protected int ySize;
    protected int guiLeft;
    protected int guiTop;
    private final ManualEntry manual;
    private GuiSideWindow sideWindow;

    public GuiItemScreen(int xSize, int ySize, ManualEntry manualEntry) {
        super((Component)ComponentFactory.literal("todo"));
        this.xSize = xSize;
        this.ySize = ySize;
        this.sideWindow = new GuiSideWindow(manualEntry.manual(), manualEntry.entry(), manualEntry.page());
        this.manual = manualEntry;
    }

    public void setWindowDimensions(int x, int y) {
        this.xSize = x;
        this.ySize = y;
        this.sideWindow = new GuiSideWindow(this.manual.manual(), this.manual.entry(), this.manual.page());
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void init() {
        super.init();
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        this.sideWindow.initGui(this.getMinecraft(), this, this.guiLeft, this.guiTop, this.xSize, this.ySize);
    }

    public boolean mouseClicked(double x, double y, int button) {
        boolean rc = super.mouseClicked(x, y, button);
        this.window.mouseClicked(x, y, button);
        this.sideWindow.getWindow().mouseClicked(x, y, button);
        return rc;
    }

    public boolean mouseDragged(double x, double y, int button, double scaledX, double scaledY) {
        boolean rc = super.mouseDragged(x, y, button, scaledX, scaledY);
        this.window.mouseDragged(x, y, button);
        this.sideWindow.getWindow().mouseDragged(x, y, button);
        return rc;
    }

    public boolean mouseScrolled(double x, double y, double dx, double dy) {
        boolean rc = super.mouseScrolled(x, y, dx, dy);
        this.window.mouseScrolled(x, y, dx, dy);
        this.sideWindow.getWindow().mouseScrolled(x, y, dx, dy);
        return rc;
    }

    public boolean mouseReleased(double x, double y, int state) {
        boolean rc = super.mouseReleased(x, y, state);
        this.window.mouseReleased(x, y, state);
        this.sideWindow.getWindow().mouseReleased(x, y, state);
        return rc;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean rc = super.keyPressed(keyCode, scanCode, modifiers);
        this.window.keyTyped(keyCode, scanCode);
        return rc;
    }

    public void drawWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        List processors;
        List properties;
        int y;
        int x;
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        this.window.draw(graphics);
        this.sideWindow.getWindow().draw(graphics);
        List<String> tooltips = this.window.getTooltips();
        if (tooltips != null) {
            x = GuiTools.getRelativeX(this);
            y = GuiTools.getRelativeY(this);
            properties = tooltips.stream().map(ComponentFactory::literal).collect(Collectors.toList());
            processors = Language.getInstance().getVisualOrder(properties);
            graphics.renderTooltip(Minecraft.getInstance().font, processors, x - this.guiLeft, y - this.guiTop);
        }
        if ((tooltips = this.sideWindow.getWindow().getTooltips()) != null) {
            x = GuiTools.getRelativeX(this);
            y = GuiTools.getRelativeY(this);
            properties = tooltips.stream().map(ComponentFactory::literal).collect(Collectors.toList());
            processors = Language.getInstance().getVisualOrder(properties);
            graphics.renderTooltip(Minecraft.getInstance().font, processors, x - this.guiLeft, y - this.guiTop);
        }
    }

    protected abstract void renderInternal(GuiGraphics var1, int var2, int var3, float var4);

    public void render(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(graphics, pMouseX, pMouseY, pPartialTick);
        this.renderInternal(graphics, pMouseX, pMouseY, pPartialTick);
    }
}

