/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils;

import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.block.IRotatable;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.CompatObjects;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BlockUtil {
    public static Optional<Direction> tryRotatingBlockAndConnected(Direction face, boolean ccw, BlockPos targetPos, Level level, Vec3 hit) {
        BlockState state = level.getBlockState(targetPos);
        Block block = state.getBlock();
        if (block instanceof IRotatable) {
            IRotatable rotatable = (IRotatable)block;
            return rotatable.rotateOverAxis(state, (LevelAccessor)level, targetPos, ccw ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90, face, hit);
        }
        Optional<Direction> special = BlockUtil.tryRotatingSpecial(face, ccw, targetPos, level, state, hit);
        if (special.isPresent()) {
            return special;
        }
        Optional<Direction> ret = BlockUtil.tryRotatingBlock(face, ccw, targetPos, level, state, hit);
        if (ret.isEmpty()) {
            ret = BlockUtil.tryRotatingBlock(Direction.UP, ccw, targetPos, level, level.getBlockState(targetPos), hit);
        }
        return ret;
    }

    public static Optional<Direction> tryRotatingBlock(Direction face, boolean ccw, BlockPos targetPos, Level level, Vec3 hit) {
        return BlockUtil.tryRotatingBlock(face, ccw, targetPos, level, level.getBlockState(targetPos), hit);
    }

    public static Optional<Direction> tryRotatingBlock(Direction dir, boolean ccw, BlockPos targetPos, Level level, BlockState state, Vec3 hit) {
        BlockState rotated;
        Block block;
        if (!level.isClientSide && CommonConfigs.Redstone.TURN_TABLE_SHUFFLE.get().booleanValue() && dir.getAxis() != Direction.Axis.Y && state.hasProperty((Property)BarrelBlock.FACING) && !state.is(ModTags.TURN_TABLE_CANT_SHUFFLE) && (block = level.getBlockEntity(targetPos)) instanceof Container) {
            Container c = (Container)block;
            BlockUtil.shuffleContainerContent(c, level);
        }
        if ((block = state.getBlock()) instanceof IRotatable) {
            IRotatable rotatable = (IRotatable)block;
            return rotatable.rotateOverAxis(state, (LevelAccessor)level, targetPos, ccw ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90, dir, hit);
        }
        Optional<BlockState> optional = BlockUtil.getRotatedState(dir, ccw, targetPos, level, state);
        if (optional.isPresent() && (rotated = optional.get()).canSurvive((LevelReader)level, targetPos) && (rotated = Block.updateFromNeighbourShapes((BlockState)rotated, (LevelAccessor)level, (BlockPos)targetPos)) != state) {
            if (level instanceof ServerLevel) {
                level.setBlock(targetPos, rotated, 11);
                level.neighborChanged(rotated, targetPos, rotated.getBlock(), targetPos, false);
            }
            return Optional.of(dir);
        }
        return Optional.empty();
    }

    public static Optional<BlockState> getRotatedState(Direction dir, boolean ccw, BlockPos targetPos, Level world, BlockState state) {
        Block verticalPlanks;
        SlabType type;
        Optional<BlockState> res;
        if (BlockUtil.isRotationBlacklisted(state)) {
            return Optional.empty();
        }
        Rotation rot = ccw ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90;
        Block block = state.getBlock();
        if (state.hasProperty((Property)ModBlockProperties.FLIPPED)) {
            return Optional.of((BlockState)state.cycle((Property)ModBlockProperties.FLIPPED));
        }
        if (dir.getAxis() == Direction.Axis.Y) {
            int bites;
            Block dc;
            if (block == Blocks.CAKE && (dc = CompatObjects.DIRECTIONAL_CAKE.get()) != null && (bites = ((Integer)state.getValue((Property)CakeBlock.BITES)).intValue()) != 0) {
                return Optional.of(ForgeHelper.rotateBlock((BlockState)((BlockState)dc.defaultBlockState().setValue((Property)CakeBlock.BITES, (Comparable)Integer.valueOf(bites))), (Level)world, (BlockPos)targetPos, (Rotation)rot));
            }
            BlockState rotated = ForgeHelper.rotateBlock((BlockState)state, (Level)world, (BlockPos)targetPos, (Rotation)rot);
            if (rotated == state) {
                rotated = BlockUtil.rotateVerticalStandard(state, rotated, rot);
            }
            return Optional.of(rotated);
        }
        if (state.hasProperty((Property)BlockStateProperties.ATTACH_FACE) && state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING) && (res = BlockUtil.getRotatedHorizontalFaceBlock(state, dir, ccw)).isPresent()) {
            return res;
        }
        if (state.hasProperty((Property)BlockStateProperties.FACING)) {
            return BlockUtil.getRotatedDirectionalBlock(state, dir, ccw);
        }
        if (state.hasProperty((Property)BlockStateProperties.AXIS)) {
            Direction.Axis targetAxis = (Direction.Axis)state.getValue((Property)BlockStateProperties.AXIS);
            Direction.Axis myAxis = dir.getAxis();
            if (myAxis == Direction.Axis.X) {
                return Optional.of((BlockState)state.setValue((Property)BlockStateProperties.AXIS, (Comparable)(targetAxis == Direction.Axis.Y ? Direction.Axis.Z : Direction.Axis.Y)));
            }
            if (myAxis == Direction.Axis.Z) {
                return Optional.of((BlockState)state.setValue((Property)BlockStateProperties.AXIS, (Comparable)(targetAxis == Direction.Axis.Y ? Direction.Axis.X : Direction.Axis.Y)));
            }
        }
        if (block instanceof StairBlock) {
            return BlockUtil.getRotatedStairs(state, dir, ccw);
        }
        if (state.hasProperty((Property)SlabBlock.TYPE)) {
            type = (SlabType)state.getValue((Property)SlabBlock.TYPE);
            if (type == SlabType.DOUBLE) {
                return Optional.empty();
            }
            return Optional.of((BlockState)state.setValue((Property)SlabBlock.TYPE, (Comparable)(type == SlabType.BOTTOM ? SlabType.TOP : SlabType.BOTTOM)));
        }
        if (state.hasProperty((Property)TrapDoorBlock.HALF)) {
            return Optional.of((BlockState)state.cycle((Property)TrapDoorBlock.HALF));
        }
        if (CompatHandler.QUARK && (type = (WoodType)WoodTypeRegistry.INSTANCE.getBlockTypeOf((ItemLike)block)) != null && type.planks == block && (verticalPlanks = type.getBlockOfThis("quark:vertical_planks")) != null) {
            return Optional.of(verticalPlanks.defaultBlockState());
        }
        return Optional.empty();
    }

    private static BlockState rotateVerticalStandard(BlockState state, BlockState rotated, Rotation rot) {
        if (state.hasProperty((Property)BlockStateProperties.FACING)) {
            rotated = (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)BlockStateProperties.FACING)));
        } else if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            rotated = (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
        } else if (state.hasProperty((Property)RotatedPillarBlock.AXIS)) {
            rotated = RotatedPillarBlock.rotatePillar((BlockState)state, (Rotation)rot);
        } else if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
            rotated = (BlockState)state.cycle((Property)BlockStateProperties.HORIZONTAL_AXIS);
        }
        return rotated;
    }

    private static boolean isRotationBlacklisted(BlockState state) {
        if (state.getBlock() instanceof BedBlock) {
            return true;
        }
        if (state.hasProperty((Property)BlockStateProperties.CHEST_TYPE) && state.getValue((Property)BlockStateProperties.CHEST_TYPE) != ChestType.SINGLE) {
            return true;
        }
        if (state.hasProperty((Property)BlockStateProperties.EXTENDED) && ((Boolean)state.getValue((Property)BlockStateProperties.EXTENDED)).booleanValue()) {
            return true;
        }
        if (state.hasProperty((Property)BlockStateProperties.SHORT)) {
            return true;
        }
        return state.is(ModTags.ROTATION_BLACKLIST);
    }

    private static Optional<Direction> tryRotatingSpecial(Direction face, boolean ccw, BlockPos pos, Level level, BlockState state, Vec3 hit) {
        Optional<Direction> opt;
        Rotation rot;
        Block b = state.getBlock();
        Rotation rotation = rot = ccw ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90;
        if (state.hasProperty((Property)BlockStateProperties.ROTATION_16)) {
            int r = (Integer)state.getValue((Property)BlockStateProperties.ROTATION_16);
            if ((r += ccw ? -1 : 1) < 0) {
                r += 16;
            }
            level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.ROTATION_16, (Comparable)Integer.valueOf(r %= 16)), 2);
            return Optional.of(Direction.UP);
        }
        if ((state.hasProperty((Property)BlockStateProperties.SHORT) || state.hasProperty((Property)PistonBaseBlock.EXTENDED) && state.hasProperty((Property)PistonBaseBlock.FACING)) && (opt = BlockUtil.rotatePistonHead(state, pos, level, face, ccw)).isPresent()) {
            return opt;
        }
        if (b instanceof BedBlock) {
            return BlockUtil.rotateBedBlock(face, pos, level, state, rot);
        }
        if (b instanceof ChestBlock) {
            return BlockUtil.rotateDoubleChest(face, pos, level, state, rot);
        }
        if (DoorBlock.isWoodenDoor((BlockState)state)) {
            // empty if block
        }
        if (CompatHandler.QUARK && QuarkCompat.tryRotateStool(level, state, pos)) {
            return Optional.of(face);
        }
        return Optional.empty();
    }

    public static void shuffleContainerContent(Container c, Level level) {
        int size = c.getContainerSize();
        boolean changed = false;
        for (int i = size - 1; i > 0; --i) {
            int j = level.random.nextInt(i + 1);
            if (i == j) continue;
            ItemStack firstItem = c.getItem(i);
            ItemStack secondItem = c.getItem(j);
            if (!c.canTakeItem(c, i, firstItem) || !c.canTakeItem(c, j, secondItem) || !c.canPlaceItem(j, firstItem) || !c.canPlaceItem(i, secondItem)) continue;
            c.setItem(i, secondItem);
            c.setItem(j, firstItem);
            changed = true;
        }
        if (changed) {
            c.setChanged();
        }
    }

    public static Optional<BlockState> getRotatedStairs(BlockState state, Direction axis, boolean ccw) {
        boolean positive;
        Direction facing = (Direction)state.getValue((Property)StairBlock.FACING);
        if (facing.getAxis() == axis.getAxis()) {
            return Optional.empty();
        }
        boolean flipped = axis.getAxisDirection() == Direction.AxisDirection.POSITIVE ^ ccw;
        Half half = (Half)state.getValue((Property)StairBlock.HALF);
        boolean top = half == Half.TOP;
        boolean bl = positive = facing.getAxisDirection() == Direction.AxisDirection.POSITIVE;
        if (top ^ positive ^ flipped) {
            half = top ? Half.BOTTOM : Half.TOP;
        } else {
            facing = facing.getOpposite();
        }
        return Optional.of((BlockState)((BlockState)state.setValue((Property)StairBlock.HALF, (Comparable)half)).setValue((Property)StairBlock.FACING, (Comparable)facing));
    }

    public static Optional<BlockState> getRotatedDirectionalBlock(BlockState state, Direction axis, boolean ccw) {
        Vec3 rotated;
        Vec3 targetNormal = MthUtils.V3itoV3((Vec3i)((Direction)state.getValue((Property)BlockStateProperties.FACING)).getNormal());
        Vec3 myNormal = MthUtils.V3itoV3((Vec3i)axis.getNormal());
        if (!ccw) {
            targetNormal = targetNormal.scale(-1.0);
        }
        if (!(rotated = myNormal.cross(targetNormal)).equals((Object)Vec3.ZERO)) {
            Direction newDir = Direction.getNearest((double)rotated.x(), (double)rotated.y(), (double)rotated.z());
            return Optional.of((BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)newDir));
        }
        return Optional.empty();
    }

    public static Optional<BlockState> getRotatedHorizontalFaceBlock(BlockState original, Direction axis, boolean ccw) {
        Direction facingDir = (Direction)original.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (facingDir.getAxis() == axis.getAxis()) {
            return Optional.empty();
        }
        AttachFace face = (AttachFace)original.getValue((Property)BlockStateProperties.ATTACH_FACE);
        return Optional.of(switch (face) {
            default -> throw new MatchException(null, null);
            case AttachFace.FLOOR -> (BlockState)((BlockState)original.setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.WALL)).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)(ccw ? axis.getClockWise() : axis.getCounterClockWise()));
            case AttachFace.CEILING -> (BlockState)((BlockState)original.setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.WALL)).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)(!ccw ? axis.getClockWise() : axis.getCounterClockWise()));
            case AttachFace.WALL -> (BlockState)original.setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)(facingDir.getAxisDirection() == Direction.AxisDirection.POSITIVE ^ (ccw ^= axis.getAxisDirection() != Direction.AxisDirection.POSITIVE) ? AttachFace.CEILING : AttachFace.FLOOR));
        });
    }

    private static Optional<Direction> rotateDoubleChest(Direction face, BlockPos pos, Level level, BlockState state, Rotation rot) {
        if (state.getValue((Property)ChestBlock.TYPE) != ChestType.SINGLE) {
            BlockState newChest = ForgeHelper.rotateBlock((BlockState)state, (Level)level, (BlockPos)pos, (Rotation)rot);
            BlockPos oldPos = pos.relative(ChestBlock.getConnectedDirection((BlockState)state));
            BlockPos targetPos = pos.relative(ChestBlock.getConnectedDirection((BlockState)newChest));
            if (level.getBlockState(targetPos).canBeReplaced()) {
                BlockState connectedNewState = ForgeHelper.rotateBlock((BlockState)level.getBlockState(oldPos), (Level)level, (BlockPos)oldPos, (Rotation)rot);
                level.setBlock(targetPos, connectedNewState, 2);
                level.setBlock(pos, newChest, 2);
                BlockEntity tile = level.getBlockEntity(oldPos);
                if (tile != null) {
                    CompoundTag tag = tile.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
                    BlockEntity blockEntity = level.getBlockEntity(targetPos);
                    if (blockEntity instanceof ChestBlockEntity) {
                        ChestBlockEntity newChestTile = (ChestBlockEntity)blockEntity;
                        newChestTile.loadWithComponents(tag, (HolderLookup.Provider)level.registryAccess());
                    }
                    tile.setRemoved();
                }
                level.setBlockAndUpdate(oldPos, Blocks.AIR.defaultBlockState());
                return Optional.of(face);
            }
        }
        return Optional.empty();
    }

    public static Optional<Direction> rotatePistonHead(BlockState state, BlockPos pos, Level level, Direction face, boolean ccw) {
        Optional<BlockState> rotatedHead;
        BlockPos newHeadPos;
        BlockState oldHead;
        BlockPos oldHeadPos;
        Optional<BlockState> newBase = BlockUtil.getRotatedDirectionalBlock(state, face, ccw);
        if (newBase.isEmpty()) {
            return Optional.empty();
        }
        BlockState newBaseState = newBase.get();
        if (state.hasProperty((Property)PistonHeadBlock.SHORT)) {
            oldHeadPos = pos.relative(((Direction)state.getValue((Property)PistonHeadBlock.FACING)).getOpposite());
            oldHead = level.getBlockState(oldHeadPos);
            if (!oldHead.hasProperty((Property)PistonBaseBlock.EXTENDED)) {
                return Optional.empty();
            }
            newHeadPos = pos.relative(((Direction)newBaseState.getValue((Property)PistonHeadBlock.FACING)).getOpposite());
        } else if (state.hasProperty((Property)PistonBaseBlock.EXTENDED)) {
            oldHeadPos = pos.relative((Direction)state.getValue((Property)PistonHeadBlock.FACING));
            oldHead = level.getBlockState(oldHeadPos);
            if (!oldHead.hasProperty((Property)PistonHeadBlock.SHORT)) {
                return Optional.empty();
            }
            newHeadPos = pos.relative((Direction)newBaseState.getValue((Property)PistonBaseBlock.FACING));
        } else {
            return Optional.empty();
        }
        if (level.getBlockState(newHeadPos).canBeReplaced() && (rotatedHead = BlockUtil.getRotatedDirectionalBlock(oldHead, face, ccw)).isPresent()) {
            level.setBlock(newHeadPos, rotatedHead.get(), 2);
            level.setBlock(pos, newBaseState, 2);
            level.removeBlock(oldHeadPos, false);
            return Optional.of(face);
        }
        return Optional.empty();
    }

    @NotNull
    public static Optional<Direction> rotateBedBlock(Direction face, BlockPos pos, Level level, BlockState state, Rotation rot) {
        BlockState newBed = ForgeHelper.rotateBlock((BlockState)state, (Level)level, (BlockPos)pos, (Rotation)rot);
        BlockPos oldPos = pos.relative(BlockUtil.getConnectedBedDirection(state));
        BlockPos targetPos = pos.relative(BlockUtil.getConnectedBedDirection(newBed));
        if (level.getBlockState(targetPos).canBeReplaced()) {
            level.setBlock(targetPos, ForgeHelper.rotateBlock((BlockState)level.getBlockState(oldPos), (Level)level, (BlockPos)oldPos, (Rotation)rot), 2);
            level.setBlock(pos, newBed, 2);
            level.removeBlock(oldPos, false);
            return Optional.of(face);
        }
        return Optional.empty();
    }

    public static Direction getConnectedBedDirection(BlockState bedState) {
        BedPart part = (BedPart)bedState.getValue((Property)BedBlock.PART);
        Direction dir = (Direction)bedState.getValue((Property)BedBlock.FACING);
        return part == BedPart.FOOT ? dir : dir.getOpposite();
    }
}

