/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.item.IFirstPersonAnimationProvider;
import net.mehvahdjukaar.moonlight.api.item.IThirdPersonAnimationProvider;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.utils.VibeChecker;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.FlanCompat;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModEnchantments;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BubbleBlowerItem
extends Item
implements IThirdPersonAnimationProvider,
IFirstPersonAnimationProvider {
    public BubbleBlowerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        VibeChecker.assertSameLevel(level, player);
        ItemStack itemstack = player.getItemInHand(hand);
        int charges = this.getCharges(itemstack);
        if (charges > 0) {
            if (EnchantmentHelper.has((ItemStack)itemstack, ModEnchantments.SPAWN_BUBBLE_BLOCK.get())) {
                return this.deployBubbleBlock(itemstack, level, player, hand);
            }
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)itemstack);
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }

    private InteractionResultHolder<ItemStack> deployBubbleBlock(ItemStack stack, Level level, Player player, InteractionHand hand) {
        HitResult result;
        double reachDistance = player.getAttributeBaseValue(Attributes.BLOCK_INTERACTION_RANGE);
        if (!player.isCreative()) {
            reachDistance = Math.min(2.0, reachDistance);
        }
        if ((result = player.pick(reachDistance, 1.0f, true)) instanceof BlockHitResult) {
            BlockHitResult hitResult = (BlockHitResult)result;
            BlockPos pos = hitResult.getBlockPos();
            BlockState first = level.getBlockState(pos);
            if (!first.canBeReplaced()) {
                pos = pos.relative(hitResult.getDirection());
            }
            if ((first = level.getBlockState(pos)).canBeReplaced()) {
                if (!level.mayInteract(player, pos) || !player.mayUseItemAt(pos, hitResult.getDirection(), stack)) {
                    return InteractionResultHolder.fail((Object)stack);
                }
                if (CompatHandler.FLAN && !FlanCompat.canPlace(player, pos)) {
                    return InteractionResultHolder.fail((Object)stack);
                }
                BlockState bubble = ModRegistry.BUBBLE_BLOCK.get().defaultBlockState();
                level.setBlockAndUpdate(pos, bubble);
                SoundType soundtype = bubble.getSoundType();
                level.playSound(player, pos, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                if (!player.getAbilities().instabuild) {
                    int charges = this.getCharges(stack);
                    stack.set(ModComponents.CHARGES.get(), (Object)Math.clamp((long)(charges - CommonConfigs.Tools.BUBBLE_BLOWER_COST.get()), 0, this.getMaxCharges(stack)));
                }
                return InteractionResultHolder.success((Object)stack);
            }
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        int charges = this.getCharges(stack);
        if (charges != 0) {
            tooltipComponents.add((Component)Component.translatable((String)"message.supplementaries.bubble_blower_tooltip", (Object[])new Object[]{charges, this.getMaxCharges(stack)}));
        }
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 72000;
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.getCharges(stack) > 0;
    }

    private int getCharges(ItemStack stack) {
        return (Integer)stack.getOrDefault(ModComponents.CHARGES.get(), (Object)0);
    }

    private int getMaxCharges(ItemStack stack) {
        return (Integer)stack.getOrDefault(ModComponents.MAX_CHARGES.get(), (Object)0);
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getBarColor(ItemStack stack) {
        return 15246564;
    }

    public int getBarWidth(ItemStack stack) {
        int charges = this.getCharges(stack);
        return Mth.clamp((int)Math.round((float)charges * 13.0f / (float)this.getCharges(stack)), (int)0, (int)13);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean allowComponentsUpdateAnimation(Player player, InteractionHand hand, ItemStack oldStack, ItemStack newStack) {
        int newCharges;
        int oldCharges = this.getCharges(oldStack);
        return oldCharges == (newCharges = this.getCharges(newStack));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        int newCharges;
        int oldCharges = this.getCharges(oldStack);
        if (oldCharges != (newCharges = this.getCharges(newStack))) {
            return false;
        }
        return !oldStack.equals(newStack);
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int remainingUseDuration) {
        int soundLength;
        block9: {
            int newCharges;
            block8: {
                int charges = this.getCharges(stack);
                newCharges = charges - 1;
                if (newCharges < 0) {
                    entity.stopUsingItem();
                    return;
                }
                if (!(entity instanceof Player)) break block8;
                Player player = (Player)entity;
                if (player.getAbilities().instabuild) break block9;
            }
            stack.set(ModComponents.CHARGES.get(), (Object)newCharges);
        }
        if (remainingUseDuration % (soundLength = 4) == 0) {
            Player pl;
            Player p = entity instanceof Player ? (pl = (Player)entity) : null;
            level.playSound(p, (Entity)entity, ModSounds.BUBBLE_BLOW.get(), entity.getSoundSource(), 1.0f, MthUtils.nextWeighted((RandomSource)level.random, (float)0.2f) + 0.95f);
        }
        if (level.isClientSide) {
            Vec3 v = entity.getViewVector(0.0f).normalize();
            double x = entity.getX() + v.x;
            double y = entity.getEyeY() + v.y - 0.12;
            double z = entity.getZ() + v.z;
            RandomSource r = entity.getRandom();
            v = v.scale(0.1 + (double)(r.nextFloat() * 0.1f));
            double dx = v.x + (0.5 - (double)r.nextFloat()) * 0.08;
            double dy = v.y + (0.5 - (double)r.nextFloat()) * 0.04;
            double dz = v.z + (0.5 - (double)r.nextFloat()) * 0.08;
            level.addParticle((ParticleOptions)ModParticles.SUDS_PARTICLE.get(), x, y, z, dx, dy, dz);
        } else if (remainingUseDuration % 10 == 0) {
            level.gameEvent((Entity)entity, (Holder)GameEvent.INSTRUMENT_PLAY, entity.position());
        }
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }

    public <T extends LivingEntity> boolean poseLeftArm(ItemStack stack, HumanoidModel<T> model, T entity, HumanoidArm mainHand) {
        if (entity.getUseItemRemainingTicks() > 0 && entity.getUseItem().getItem() == this) {
            this.animateHands(model, entity, true);
            return true;
        }
        return false;
    }

    public <T extends LivingEntity> boolean poseRightArm(ItemStack stack, HumanoidModel<T> model, T entity, HumanoidArm mainHand) {
        if (entity.getUseItemRemainingTicks() > 0 && entity.getUseItem().getItem() == this) {
            this.animateHands(model, entity, false);
            return true;
        }
        return false;
    }

    public <T extends LivingEntity> void animateHands(HumanoidModel<T> model, T entity, boolean leftHand) {
        ModelPart mainHand = leftHand ? model.leftArm : model.rightArm;
        int dir = leftHand ? -1 : 1;
        float cr = entity.isCrouching() ? 0.3f : 0.0f;
        float headXRot = MthUtils.wrapRad((float)model.head.xRot);
        float headYRot = MthUtils.wrapRad((float)model.head.yRot);
        float pitch = Mth.clamp((float)headXRot, (float)-1.6f, (float)0.8f) + 0.55f;
        mainHand.xRot = (float)((double)(pitch - cr) - 1.5707963267948966) - (float)dir * 0.3f * headYRot;
        float yaw = 0.7f * (float)dir;
        mainHand.yRot = Mth.clamp((float)(-yaw * Mth.cos((float)pitch) + headYRot), (float)-1.1f, (float)1.1f);
        mainHand.zRot = -yaw * Mth.sin((float)pitch);
        AnimationUtils.bobModelPart((ModelPart)mainHand, (float)entity.tickCount, (float)(-dir));
    }

    public void animateItemFirstPerson(Player player, ItemStack stack, InteractionHand hand, HumanoidArm humanoidArm, PoseStack poseStack, float partialTicks, float v1, float v2, float v3) {
        if (player.isUsingItem() && player.getUseItemRemainingTicks() > 0 && player.getUsedItemHand() == hand) {
            float timeLeft = (float)stack.getUseDuration((LivingEntity)player) - ((float)player.getUseItemRemainingTicks() - partialTicks + 1.0f);
            float f12 = 1.0f;
            if (f12 > 0.1f) {
                float f15 = Mth.sin((float)((timeLeft - 0.1f) * 1.3f));
                float f18 = f12 - 0.1f;
                float f20 = f15 * f18;
                poseStack.translate(0.0f, f20 * 0.004f, 0.0f);
            }
            poseStack.translate(0.0f, 0.0f, f12 * 0.04f);
            poseStack.scale(1.0f, 1.0f, 1.0f + f12 * 0.2f);
        }
    }
}

