/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.stream.IntStream;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.common.block.blocks.HourGlassBlock;
import net.mehvahdjukaar.supplementaries.common.block.hourglass.HourglassTimeData;
import net.mehvahdjukaar.supplementaries.common.block.hourglass.HourglassTimesManager;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class HourGlassBlockTile
extends ItemDisplayTile {
    private HourglassTimeData sandData = HourglassTimeData.EMPTY;
    private float progress = 0.0f;
    private float prevProgress = 0.0f;
    private int power = 0;
    private ResourceLocation cachedTexture = null;

    public HourGlassBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.HOURGLASS_TILE.get(), pos, state);
    }

    public void updateTileOnInventoryChanged() {
        this.sandData = HourglassTimesManager.getInstance((HolderLookup.Provider)this.level.registryAccess()).getData(this.getDisplayedItem().getItem());
        boolean p = this.getDirection() == Direction.DOWN;
        int l = this.sandData.light();
        if (l != (Integer)this.getBlockState().getValue((Property)HourGlassBlock.LIGHT_LEVEL) && this.level != null) {
            this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)HourGlassBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(l)), 20);
        }
        this.prevProgress = (float)p;
        this.progress = (float)p;
    }

    public void updateClientVisualsOnLoad() {
        super.updateClientVisualsOnLoad();
        this.sandData = HourglassTimesManager.getInstance((HolderLookup.Provider)this.level.registryAccess()).getData(this.getDisplayedItem().getItem());
        this.cachedTexture = null;
    }

    public HourglassTimeData getSandData() {
        return this.sandData;
    }

    public float getProgress(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.prevProgress, (float)this.progress);
    }

    public ResourceLocation getTexture() {
        if (this.cachedTexture == null) {
            this.cachedTexture = this.sandData.computeTexture(this.getDisplayedItem(), this.level);
        }
        return this.cachedTexture;
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, HourGlassBlockTile tile) {
        int p;
        Direction dir = (Direction)pState.getValue((Property)HourGlassBlock.FACING);
        if (!tile.sandData.isEmpty()) {
            tile.prevProgress = tile.progress;
            if (dir == Direction.UP && tile.progress != 1.0f) {
                tile.progress = Math.min(tile.progress + tile.sandData.getIncrement(), 1.0f);
            } else if (dir == Direction.DOWN && tile.progress != 0.0f) {
                tile.progress = Math.max(tile.progress - tile.sandData.getIncrement(), 0.0f);
            }
        }
        if (!pLevel.isClientSide && (p = dir == Direction.DOWN ? 1 + (int)((1.0f - tile.progress) * 14.0f) : 1 + (int)(tile.progress * 14.0f)) != tile.power) {
            tile.power = p;
            pLevel.updateNeighbourForOutputSignal(pPos, pState.getBlock());
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        this.progress = tag.getFloat("Progress");
        this.prevProgress = tag.getFloat("PrevProgress");
        this.cachedTexture = null;
        this.sandData = HourglassTimeData.EMPTY;
        super.loadAdditional(tag, registries);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putFloat("Progress", this.progress);
        tag.putFloat("PrevProgress", this.prevProgress);
    }

    public Component getDefaultName() {
        return Component.translatable((String)"block.supplementaries.hourglass");
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return this.isEmpty() && !HourglassTimesManager.getInstance(this.level).getData(stack.getItem()).isEmpty();
    }

    public int[] getSlotsForFace(Direction side) {
        return IntStream.range(0, this.getContainerSize()).toArray();
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        if (direction == Direction.UP) {
            return this.canPlaceItem(0, stack);
        }
        return false;
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        Direction dir = (Direction)this.getBlockState().getValue((Property)HourGlassBlock.FACING);
        return dir == Direction.UP && this.progress == 1.0f || dir == Direction.DOWN && this.progress == 0.0f;
    }

    public Direction getDirection() {
        return (Direction)this.getBlockState().getValue((Property)HourGlassBlock.FACING);
    }

    public int getPower() {
        return this.power;
    }

    public SoundEvent getAddItemSound() {
        return SoundEvents.SAND_PLACE;
    }
}

