/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.screens;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.moonlight.api.client.util.TextUtil;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.SignPostBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.screens.TextHolderEditScreen;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SignPostBlockTile;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.FramedBlocksCompat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.state.BlockState;

public class SignPostScreen
extends TextHolderEditScreen<SignPostBlockTile> {
    private SignPostScreen(SignPostBlockTile tile) {
        super(tile, (Component)Component.translatable((String)"sign.edit"));
        this.textHolderIndex = !((SignPostBlockTile)this.tile).getSignUp().active() ? 1 : 0;
    }

    public static void open(SignPostBlockTile teSign) {
        Minecraft.getInstance().setScreen((Screen)new SignPostScreen(teSign));
    }

    @Override
    protected boolean canScroll() {
        return ((SignPostBlockTile)this.tile).getSignUp().active() && ((SignPostBlockTile)this.tile).getSignDown().active();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 40, 0xFFFFFF);
        Lighting.setupForFlatItems();
        PoseStack poseStack = graphics.pose();
        MultiBufferSource.BufferSource bufferSource = graphics.bufferSource();
        poseStack.pushPose();
        poseStack.translate((double)this.width / 2.0, 0.0, 50.0);
        poseStack.scale(93.75f, -93.75f, 93.75f);
        poseStack.translate(0.0, -1.3125, 0.0);
        poseStack.pushPose();
        BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
        SignPostBlockTile.Sign signUp = ((SignPostBlockTile)this.tile).getSignUp();
        SignPostBlockTile.Sign signDown = ((SignPostBlockTile)this.tile).getSignDown();
        boolean leftUp = signUp.left();
        boolean leftDown = signDown.left();
        int[] o = new int[]{leftUp ? 1 : -1, leftDown ? 1 : -1};
        boolean blink = this.updateCounter / 6 % 2 == 0;
        ModelBlockRenderer modelRenderer = blockRenderer.getModelRenderer();
        poseStack.pushPose();
        this.renderSign(poseStack, modelRenderer, (MultiBufferSource)bufferSource, signUp, leftUp);
        poseStack.translate(0.0, -0.5, 0.0);
        this.renderSign(poseStack, modelRenderer, (MultiBufferSource)bufferSource, signDown, leftDown);
        poseStack.popPose();
        poseStack.translate(-0.5, -0.5, -0.5);
        BlockState fence = ((SignPostBlockTile)this.tile).getHeldBlock();
        if (CompatHandler.FRAMEDBLOCKS && ((SignPostBlockTile)this.tile).isFramed()) {
            fence = FramedBlocksCompat.getFramedFence();
        }
        if (fence != null) {
            blockRenderer.renderSingleBlock(fence, poseStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY);
        }
        poseStack.popPose();
        if (signUp.active() || signDown.active()) {
            TextUtil.RenderProperties properties;
            poseStack.translate((double)(-0.03125f * (float)o[0]), 0.21875, 0.1925);
            poseStack.scale(0.010416667f, -0.010416667f, 0.010416667f);
            int cursorPos = this.textInputUtil.getCursorPos();
            int selectionPos = this.textInputUtil.getSelectionPos();
            if (signUp.active()) {
                properties = ((SignPostBlockTile)this.tile).getTextHolder(0).getGUIRenderTextProperties();
                TextUtil.renderGuiLine((TextUtil.RenderProperties)properties, (String)this.messages[0][0], (Font)this.font, (GuiGraphics)graphics, (MultiBufferSource.BufferSource)bufferSource, (int)cursorPos, (int)selectionPos, (this.textHolderIndex == 0 ? 1 : 0) != 0, (boolean)blink, (int)-10);
            }
            if (signDown.active()) {
                poseStack.translate((float)(-3 * o[1]), 0.0f, 0.0f);
                properties = ((SignPostBlockTile)this.tile).getTextHolder(1).getGUIRenderTextProperties();
                TextUtil.renderGuiLine((TextUtil.RenderProperties)properties, (String)this.messages[1][0], (Font)this.font, (GuiGraphics)graphics, (MultiBufferSource.BufferSource)bufferSource, (int)cursorPos, (int)selectionPos, (this.textHolderIndex == 1 ? 1 : 0) != 0, (boolean)blink, (int)38);
            }
        }
        poseStack.popPose();
        Lighting.setupFor3DItems();
    }

    private void renderSign(PoseStack poseStack, ModelBlockRenderer renderer, MultiBufferSource bufferSource, SignPostBlockTile.Sign sign, boolean leftDown) {
        if (sign.active()) {
            poseStack.pushPose();
            if (!leftDown) {
                poseStack.mulPose(RotHlpr.YN180);
                poseStack.translate(0.0, 0.0, -0.55);
            } else {
                poseStack.translate(0.0, 0.0, -0.3);
            }
            poseStack.translate(-0.5, 0.0, 0.0);
            renderer.renderModel(poseStack.last(), bufferSource.getBuffer(RenderType.cutout()), null, SignPostBlockTileRenderer.MODELS.get(sign.woodType()), 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
    }
}

