/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.items;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.client.ItemStackRenderer;
import net.mehvahdjukaar.moonlight.api.client.model.BakedQuadBuilder;
import net.mehvahdjukaar.moonlight.api.client.util.VertexUtil;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class AltimeterItemRenderer
extends ItemStackRenderer {
    private static final Map<ResourceKey<Level>, Pair<TextureAtlasSprite, Int2ObjectMap<BakedModel>>> MODEL_CACHE = new HashMap<ResourceKey<Level>, Pair<TextureAtlasSprite, Int2ObjectMap<BakedModel>>>();

    public static Map<ResourceKey<Level>, Pair<TextureAtlasSprite, Int2ObjectMap<BakedModel>>> getModelCache() {
        if (MODEL_CACHE.isEmpty()) {
            ArrayList<ResourceLocation> resourceLocations = new ArrayList<ResourceLocation>((Collection)ClientConfigs.Items.DEPTH_METER_DIMENSIONS.get());
            resourceLocations.add(Level.OVERWORLD.location());
            for (ResourceLocation d : resourceLocations) {
                ResourceKey res = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)d);
                TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(Supplementaries.res("item/altimeter/" + d.toString().replace(":", "_")));
                if (sprite == null) continue;
                MODEL_CACHE.put((ResourceKey<Level>)res, (Pair<TextureAtlasSprite, Int2ObjectMap<BakedModel>>)Pair.of((Object)sprite, (Object)new Int2ObjectOpenHashMap()));
            }
        }
        return MODEL_CACHE;
    }

    public static void onReload() {
        MODEL_CACHE.clear();
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        ClientLevel level = Minecraft.getInstance().level;
        ResourceKey dimension = level == null ? Level.OVERWORLD : level.dimension();
        Map<ResourceKey<Level>, Pair<TextureAtlasSprite, Int2ObjectMap<BakedModel>>> cache = AltimeterItemRenderer.getModelCache();
        Pair<TextureAtlasSprite, Int2ObjectMap<BakedModel>> pair = cache.getOrDefault(dimension, cache.get(Level.OVERWORLD));
        if (pair == null) {
            Supplementaries.error();
            return;
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)pair.getFirst();
        int textureH = sprite.contents().height();
        double stripDepth = AltimeterItemRenderer.calculateDepthIndex(level, textureH);
        int mult = ClientConfigs.Items.DEPTH_METER_STEP_MULT.get();
        int index = (int)Math.round(stripDepth * (double)mult);
        BakedModel model = (BakedModel)((Int2ObjectMap)pair.getSecond()).computeIfAbsent(index, i -> new AltimeterModel((float)index / (float)mult, textureH, sprite));
        Minecraft.getInstance().getItemRenderer().render(Items.DIAMOND.getDefaultInstance(), transformType, false, poseStack, buffer, packedLight, packedOverlay, model);
        poseStack.popPose();
    }

    private static double calculateDepthIndex(@Nullable ClientLevel level, int textureH) {
        int min = level == null ? -64 : level.getMinBuildHeight();
        int max = level == null ? 312 : level.getMaxBuildHeight();
        LocalPlayer player = Minecraft.getInstance().player;
        double depth = player == null ? 64.0 : player.position().y;
        double normDepth = Mth.clamp((double)((depth - (double)min) / (double)(max - min)), (double)0.0, (double)1.0);
        return normDepth * (double)(textureH - 6);
    }

    private static class AltimeterModel
    implements BakedModel {
        private final List<BakedQuad> quads = new ArrayList<BakedQuad>();
        private final ItemOverrides overrides;
        private final ItemTransforms transforms;

        AltimeterModel(float depth, int textureH, TextureAtlasSprite sprite) {
            int h = 5;
            float invDepth = (float)textureH - depth - (float)h;
            float shrink = sprite.uvShrinkRatio();
            try (BakedQuadBuilder builder = BakedQuadBuilder.create((TextureAtlasSprite)sprite, this.quads::add);){
                builder.setAutoDirection();
                PoseStack ps = new PoseStack();
                float u0 = 0.0f;
                float u1 = 0.25f;
                float u3 = 0.25f;
                float u4 = 0.5f;
                for (int j = 0; j < 2; ++j) {
                    ps.translate(0.0f, 0.0f, 0.46875f);
                    AltimeterModel.addScaledQuad(builder, ps, shrink, false, 0.375f, 0.375f, 0.625f, 0.6875f, u0, invDepth / (float)textureH, u1, (invDepth + (float)h) / (float)textureH);
                    AltimeterModel.addScaledQuad(builder, ps, shrink, true, 0.375f, 0.6875f, 0.625f, 0.75f, u3, (invDepth - 1.0f) / (float)textureH, u4, invDepth / (float)textureH);
                    ps.scale(-1.0f, 1.0f, -1.0f);
                    ps.translate(-1.0f, 0.0f, -0.53125f);
                    u0 = 0.25f;
                    u1 = 0.0f;
                    u3 = 0.5f;
                    u4 = 0.25f;
                }
            }
            catch (Exception e) {
                Supplementaries.error("Failed to create altimeter model", new Object[0]);
            }
            BakedModel copy = ClientHelper.getModel((ModelManager)Minecraft.getInstance().getModelManager(), (ModelResourceLocation)ClientRegistry.ALTIMETER_TEMPLATE);
            this.quads.addAll(copy.getQuads(null, null, RandomSource.create()));
            this.overrides = copy.getOverrides();
            this.transforms = copy.getTransforms();
        }

        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, RandomSource random) {
            return direction == null ? this.quads : List.of();
        }

        public boolean useAmbientOcclusion() {
            return false;
        }

        public boolean isGui3d() {
            return false;
        }

        public boolean usesBlockLight() {
            return false;
        }

        public boolean isCustomRenderer() {
            return false;
        }

        public TextureAtlasSprite getParticleIcon() {
            return null;
        }

        public ItemTransforms getTransforms() {
            return this.transforms;
        }

        public ItemOverrides getOverrides() {
            return this.overrides;
        }

        private static void addScaledQuad(BakedQuadBuilder builder, PoseStack ps, float shrink, boolean top, float x0, float y0, float x1, float y1, float u0, float v0, float u1, float v1) {
            float ix0 = shrink * (x0 - 0.5f) * 2.0f;
            float ix1 = shrink * (x1 - 0.5f) * 2.0f;
            float iy0 = top ? 0.0f : shrink * (y0 - 0.5f) * 2.0f;
            float iy1 = !top ? 0.0f : shrink * (y1 - 0.5f) * 2.0f;
            VertexUtil.addQuad((VertexConsumer)builder, (PoseStack)ps, (float)(x0 + ix0), (float)(y0 + iy0), (float)(x1 + ix1), (float)(y1 + iy1), (float)(u0 / 16.0f), (float)(v0 / 16.0f), (float)(u1 / 16.0f), (float)(v1 / 16.0f), (int)255, (int)255, (int)255, (int)255, (int)0, (int)0);
        }
    }
}

