/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.mehvahdjukaar.supplementaries.common.entities.SlingshotProjectileEntity;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;

public class SlingshotProjectileRenderer<T extends SlingshotProjectileEntity>
extends EntityRenderer<T> {
    private final ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();

    public SlingshotProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    protected int getBlockLightLevel(T entity, BlockPos pos) {
        return ((SlingshotProjectileEntity)((Object)entity)).getLightEmission();
    }

    public void render(T entity, float pEntityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        if (((SlingshotProjectileEntity)((Object)entity)).tickCount < 2 && this.entityRenderDispatcher.camera.getPosition().distanceToSqr(entity.position()) < 7.0) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.0, 0.25, 0.0);
        poseStack.mulPose(Axis.YN.rotationDegrees(180.0f - Mth.rotLerp((float)partialTicks, (float)((SlingshotProjectileEntity)((Object)entity)).yRotO, (float)entity.getYRot())));
        poseStack.mulPose(Axis.ZN.rotationDegrees(Mth.rotLerp((float)partialTicks, (float)((SlingshotProjectileEntity)((Object)entity)).xRotO, (float)entity.getXRot())));
        float scale = (float)ClientConfigs.Items.SLINGSHOT_PROJECTILE_SCALE.get().doubleValue();
        poseStack.scale(scale, scale, scale);
        this.itemRenderer.renderStatic(entity.getItem(), ItemDisplayContext.NONE, light, OverlayTexture.NO_OVERLAY, poseStack, buffer, entity.level(), 0);
        poseStack.popPose();
        super.render(entity, pEntityYaw, partialTicks, poseStack, buffer, light);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

