/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.ars.common.crafting.requirement.jei;

import com.mojang.datafixers.util.Pair;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.ars.ModularMachineryRebornArs;
import es.degrassi.mmreborn.ars.client.requirement.SourceRendering;
import es.degrassi.mmreborn.ars.common.crafting.requirement.RequirementSource;
import es.degrassi.mmreborn.ars.common.machine.component.SourceComponent;
import es.degrassi.mmreborn.common.crafting.MachineRecipe;
import es.degrassi.mmreborn.common.crafting.requirement.PositionedSizedRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.jei.JeiComponent;
import es.degrassi.mmreborn.common.data.Config;
import es.degrassi.mmreborn.common.integration.jei.category.MMRRecipeCategory;
import es.degrassi.mmreborn.common.integration.jei.category.drawable.DrawableWrappedText;
import es.degrassi.mmreborn.common.integration.jei.ingredient.CustomIngredientTypes;
import es.degrassi.mmreborn.common.util.TextureSizeHelper;
import es.degrassi.mmreborn.common.util.Utils;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.TooltipFlag;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.NotNull;

public class JeiSourceComponent
extends JeiComponent<Integer, RecipeRequirement<SourceComponent, RequirementSource>>
implements SourceRendering {
    private int width = 14;
    private int height = 14;

    public JeiSourceComponent(RecipeRequirement<SourceComponent, RequirementSource> requirement) {
        super(requirement, 0, 0);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ResourceLocation texture() {
        return ModularMachineryRebornArs.rl("textures/gui/jeirecipeicons.png");
    }

    public void render(GuiGraphics guiGraphics, Integer ingredient) {
        this.width += 4;
        this.height += 4;
        guiGraphics.blit(this.texture(), -2, -2, 0, (float)this.uOffset, (float)this.vOffset, this.getWidth(), this.getHeight(), TextureSizeHelper.getWidth((ResourceLocation)this.texture()), TextureSizeHelper.getHeight((ResourceLocation)this.texture()));
        this.width -= 4;
        this.height -= 4;
        this.renderSource(guiGraphics, this.width, this.height);
    }

    public List<Integer> ingredients() {
        return Lists.newArrayList(List.of(((RequirementSource)this.requirement.requirement()).required).iterator());
    }

    @NotNull
    public List<Component> getTooltip(@NotNull Integer ingredient, @NotNull TooltipFlag tooltipFlag) {
        List tooltip = super.getTooltip((Object)ingredient, tooltipFlag);
        String mode = ((RequirementSource)this.requirement.requirement()).getMode().isInput() ? "input" : "output";
        float chance = this.requirement.chance();
        String chanceS = Utils.decimalFormatWithPercentage((double)(chance * 100.0f));
        if (chance == 1.0f) {
            tooltip.add(Component.translatable((String)("modular_machinery_reborn_ars.jei.ingredient.source." + mode), (Object[])new Object[]{((RequirementSource)this.requirement.requirement()).required}));
        } else {
            if (chance == 0.0f) {
                tooltip.add(Component.translatable((String)"modular_machinery_reborn.ingredient.chance.not_consumed"));
            } else if (chance > 0.0f && chance < 1.0f) {
                tooltip.add(Component.translatable((String)("modular_machinery_reborn.ingredient.chance." + mode), (Object[])new Object[]{chanceS, ""}));
            }
            tooltip.add(Component.translatable((String)"modular_machinery_reborn_ars.jei.ingredient.source.amount", (Object[])new Object[]{((RequirementSource)this.requirement.requirement()).required}));
        }
        return tooltip;
    }

    public void setRecipe(MMRRecipeCategory category, IRecipeLayoutBuilder builder, MachineRecipe recipe, IFocusGroup focuses) {
        MutableComponent component = Component.empty();
        String chance = Utils.decimalFormat((double)(this.requirement.chance() * 100.0f));
        if (this.requirement.chance() > 0.0f && this.requirement.chance() < 1.0f) {
            component = Component.translatable((String)"modular_machinery_reborn.ingredient.chance", (Object[])new Object[]{chance, "%"}).withColor(Config.chanceColor);
        } else if (this.requirement.chance() == 0.0f) {
            component = Component.translatable((String)"modular_machinery_reborn.ingredient.chance.nc").withColor(Config.chanceColor);
        }
        Font font = Minecraft.getInstance().font;
        List list = recipe.chanceTexts;
        PositionedSizedRequirement positionedSizedRequirement = new PositionedSizedRequirement(this.getPosition().x(), this.getPosition().y(), this.getWidth(), font.wordWrapHeight((FormattedText)component, this.getWidth()));
        DrawableWrappedText drawableWrappedText = new DrawableWrappedText(List.of(component), this.getWidth() + 2, true).transform(DrawableWrappedText.Operation.SET, DrawableWrappedText.State.TRANSLATEX, (double)this.getPosition().x()).transform(DrawableWrappedText.Operation.SET, DrawableWrappedText.State.TRANSLATEY, (double)this.getPosition().y()).transform(DrawableWrappedText.Operation.SET, DrawableWrappedText.State.SCALE, 0.75).transform(DrawableWrappedText.Operation.SET, DrawableWrappedText.State.TRANSLATEZ, 500.0).transform(DrawableWrappedText.Operation.SET, DrawableWrappedText.State.TRANSLATEX, (double)(this.getWidth() - 16) / 2.0).transform(DrawableWrappedText.Operation.ADD, DrawableWrappedText.State.TRANSLATEX, 17.0).transform(DrawableWrappedText.Operation.REMOVE, DrawableWrappedText.State.TRANSLATEX, (double)Math.min(14, font.width((FormattedText)component))).transform(DrawableWrappedText.Operation.SET, DrawableWrappedText.State.TRANSLATEY, (double)(this.getHeight() - 16) / 2.0).transform(DrawableWrappedText.Operation.REMOVE, DrawableWrappedText.State.TRANSLATEY, 1.0);
        Objects.requireNonNull(font);
        list.add(Pair.of((Object)positionedSizedRequirement, (Object)drawableWrappedText.transform(DrawableWrappedText.Operation.ADD, DrawableWrappedText.State.TRANSLATEY, 9.0 * 3.0 / 2.0)));
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, this.getPosition().x() + 1, this.getPosition().y() + 1).setCustomRenderer(CustomIngredientTypes.INTEGER, (IIngredientRenderer)this).addIngredients(CustomIngredientTypes.INTEGER, this.ingredients());
    }
}

