/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.ars.common.crafting.requirement.emi;

import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.ars.ModularMachineryRebornArs;
import es.degrassi.mmreborn.ars.client.requirement.SourceRendering;
import es.degrassi.mmreborn.ars.common.crafting.requirement.RequirementSource;
import es.degrassi.mmreborn.ars.common.machine.component.SourceComponent;
import es.degrassi.mmreborn.client.requirement.ChanceRendering;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiComponent;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.util.Utils;
import java.util.List;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.NotNull;

public class EmiSourceComponent
extends EmiComponent<Integer, RecipeRequirement<SourceComponent, RequirementSource>>
implements SourceRendering,
ChanceRendering {
    private int width = 14;
    private int height = 14;

    public EmiSourceComponent(RecipeRequirement<SourceComponent, RequirementSource> requirement) {
        super(requirement, 0, 0);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.width += 4;
        this.height += 4;
        super.render(guiGraphics, mouseX, mouseY);
        this.width -= 4;
        this.height -= 4;
        this.renderSource(guiGraphics, this.width, this.height, 2, 2);
        this.drawChance(guiGraphics, false);
    }

    public int getXHighlight() {
        return 2;
    }

    public int getYHighlight() {
        return 2;
    }

    public List<Component> getTooltip() {
        List tooltip = super.getTooltip();
        String mode = ((RequirementSource)this.requirement.requirement()).getMode().isInput() ? "input" : "output";
        float chance = this.requirement.chance();
        String chanceS = Utils.decimalFormatWithPercentage((double)(chance * 100.0f));
        if (chance == 1.0f) {
            tooltip.add(Component.translatable((String)("modular_machinery_reborn_ars.jei.ingredient.source." + mode), (Object[])new Object[]{((RequirementSource)this.requirement.requirement()).required}));
        } else {
            if (chance == 0.0f) {
                tooltip.add(Component.translatable((String)"modular_machinery_reborn.ingredient.chance.not_consumed"));
            } else if (chance > 0.0f && chance < 1.0f) {
                tooltip.add(Component.translatable((String)("modular_machinery_reborn.ingredient.chance." + mode), (Object[])new Object[]{chanceS, ""}));
            }
            tooltip.add(Component.translatable((String)"modular_machinery_reborn_ars.jei.ingredient.source.amount", (Object[])new Object[]{((RequirementSource)this.requirement.requirement()).required}));
        }
        return tooltip;
    }

    public List<Integer> ingredients() {
        return Lists.newArrayList(List.of(((RequirementSource)this.requirement.requirement()).required).iterator());
    }

    @NotNull
    public ResourceLocation texture() {
        return ModularMachineryRebornArs.rl("textures/gui/jeirecipeicons.png");
    }

    public float getChance() {
        return this.requirement.chance();
    }

    public IOType getActionType() {
        return ((RequirementSource)this.requirement.requirement()).getMode();
    }

    @Generated
    public int getWidth() {
        return this.width;
    }

    @Generated
    public int getHeight() {
        return this.height;
    }
}

