/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.ars.common.crafting.requirement;

import com.hollingsworth.arsnouveau.common.capability.SourceStorage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.api.crafting.CraftingResult;
import es.degrassi.mmreborn.api.crafting.ICraftingContext;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirement;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirementList;
import es.degrassi.mmreborn.ars.common.machine.component.SourceComponent;
import es.degrassi.mmreborn.ars.common.registration.ComponentRegistration;
import es.degrassi.mmreborn.ars.common.registration.RequirementTypeRegistration;
import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.crafting.modifier.RecipeModifier;
import es.degrassi.mmreborn.common.crafting.requirement.PositionedRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.machine.IOType;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class RequirementSource
implements IRequirement<SourceComponent> {
    public static final NamedCodec<RequirementSource> CODEC = NamedCodec.record(instance -> instance.group((App)NamedCodec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("source").forGetter(req -> req.required), (App)NamedCodec.enumCodec(IOType.class).fieldOf("mode").forGetter(IRequirement::getMode), (App)PositionedRequirement.POSITION_CODEC.optionalFieldOf("position", (Object)new PositionedRequirement(0, 0)).forGetter(IRequirement::getPosition)).apply((Applicative)instance, (source, mode, position) -> new RequirementSource((IOType)mode, (Integer)source, (PositionedRequirement)position)), (String)"SourceRequirement");
    public final Integer required;
    private final IOType mode;
    private final PositionedRequirement position;

    public RequirementSource(IOType mode, Integer source, PositionedRequirement position) {
        this.mode = mode;
        this.required = source;
        this.position = position;
    }

    public RequirementType<RequirementSource> getType() {
        return RequirementTypeRegistration.SOURCE.get();
    }

    public ComponentType getComponentType() {
        return ComponentRegistration.COMPONENT_SOURCE.get();
    }

    public boolean test(SourceComponent component, ICraftingContext context) {
        SourceStorage handler = component.getContainerProvider();
        if (handler == null) {
            return false;
        }
        int amount = (int)context.getModifiedValue((float)this.required.intValue(), (IRequirement)this);
        return switch (this.mode) {
            default -> throw new MatchException(null, null);
            case IOType.INPUT -> {
                if (handler.extractSource(amount, true) >= amount) {
                    yield true;
                }
                yield false;
            }
            case IOType.OUTPUT -> handler.receiveSource(amount, true) >= amount;
        };
    }

    public void gatherRequirements(IRequirementList<SourceComponent> list) {
        switch (this.getMode()) {
            case INPUT: {
                list.processOnStart(this::processInput);
                break;
            }
            case OUTPUT: {
                list.processOnEnd(this::processOutput);
            }
        }
    }

    private CraftingResult processOutput(SourceComponent component, ICraftingContext context) {
        int amount;
        SourceStorage handler = component.getContainerProvider();
        int remaining = handler.receiveSource(amount = (int)context.getModifiedValue((float)this.required.intValue(), (IRequirement)this), true);
        if (remaining >= amount) {
            handler.receiveSource(amount, false);
            return CraftingResult.success();
        }
        return CraftingResult.error((Component)Component.translatable((String)"craftcheck.failure.source.output", (Object[])new Object[]{amount, component.getContainerProvider().getSourceCapacity() - component.getContainerProvider().getSource()}));
    }

    private CraftingResult processInput(SourceComponent component, ICraftingContext context) {
        int amount = (int)context.getModifiedValue((float)this.required.intValue(), (IRequirement)this);
        int canExtract = component.getContainerProvider().extractSource(amount, true);
        if (canExtract >= amount) {
            component.getContainerProvider().extractSource(amount, false);
            return CraftingResult.success();
        }
        return CraftingResult.error((Component)Component.translatable((String)"craftcheck.failure.source.input", (Object[])new Object[]{amount, component.getContainerProvider().getSource()}));
    }

    public RequirementSource deepCopyModified(List<RecipeModifier> modifiers) {
        int amount = Math.round(RecipeModifier.applyModifiers(modifiers, this.getType(), (IOType)this.getMode(), (float)this.required.intValue(), (boolean)false));
        return new RequirementSource(this.getMode(), amount, this.getPosition());
    }

    public RequirementSource deepCopy() {
        return new RequirementSource(this.getMode(), this.required, this.getPosition());
    }

    @NotNull
    public Component getMissingComponentErrorMessage(IOType ioType) {
        return Component.translatable((String)String.format("component.missing.source.%s", ioType.name().toLowerCase(Locale.ROOT)));
    }

    public boolean isComponentValid(SourceComponent sourceComponent, ICraftingContext iCraftingContext) {
        return this.getMode().equals((Object)sourceComponent.getIOType());
    }

    @Generated
    public IOType getMode() {
        return this.mode;
    }

    @Generated
    public PositionedRequirement getPosition() {
        return this.position;
    }
}

