/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.surface.rule;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SurfaceRules;

public record TransientMergedRule(List<SurfaceRules.RuleSource> sequence, SurfaceRules.RuleSource original) implements SurfaceRules.RuleSource
{
    public static final KeyDispatchDataCodec<SurfaceRules.RuleSource> CODEC = KeyDispatchDataCodec.of((MapCodec)SurfaceRules.RuleSource.CODEC.xmap(source -> source, source -> {
        SurfaceRules.RuleSource ruleSource;
        if (source instanceof TransientMergedRule) {
            TransientMergedRule transientMerged = (TransientMergedRule)source;
            ruleSource = transientMerged.original;
        } else {
            ruleSource = source;
        }
        return ruleSource;
    }).fieldOf("original_source"));

    public KeyDispatchDataCodec<? extends SurfaceRules.RuleSource> codec() {
        return CODEC;
    }

    public SurfaceRules.SurfaceRule apply(SurfaceRules.Context context) {
        if (this.sequence.size() == 1) {
            return (SurfaceRules.SurfaceRule)this.sequence.getFirst().apply((Object)context);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SurfaceRules.RuleSource ruleSource : this.sequence) {
            builder.add((Object)((SurfaceRules.SurfaceRule)ruleSource.apply((Object)context)));
        }
        builder.add((Object)((SurfaceRules.SurfaceRule)this.original.apply((Object)context)));
        return (x, y, z) -> {
            for (SurfaceRules.SurfaceRule surfaceRule : builder.build()) {
                BlockState blockstate = surfaceRule.tryApply(x, y, z);
                if (blockstate == null) continue;
                return blockstate;
            }
            return null;
        };
    }
}

