/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gui.frame;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import org.embeddedt.embeddium.api.math.Dim2i;
import org.embeddedt.embeddium.api.options.control.ControlElement;
import org.embeddedt.embeddium.impl.gui.widgets.AbstractWidget;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFrame
extends AbstractWidget
implements ContainerEventHandler {
    protected Dim2i dim;
    protected final List<AbstractWidget> children = new ArrayList<AbstractWidget>();
    protected final List<Renderable> drawable = new ArrayList<Renderable>();
    protected final List<ControlElement<?>> controlElements = new ArrayList();
    protected boolean renderOutline;
    private GuiEventListener focused;
    private boolean dragging;
    private Consumer<GuiEventListener> focusListener;

    public AbstractFrame(Dim2i dim, boolean renderOutline) {
        this.dim = dim;
        this.renderOutline = renderOutline;
    }

    public void buildFrame() {
        for (GuiEventListener guiEventListener : this.children) {
            if (guiEventListener instanceof AbstractFrame) {
                this.controlElements.addAll(((AbstractFrame)guiEventListener).controlElements);
            }
            if (guiEventListener instanceof ControlElement) {
                this.controlElements.add((ControlElement)guiEventListener);
            }
            if (!(guiEventListener instanceof Renderable)) continue;
            this.drawable.add((Renderable)guiEventListener);
        }
    }

    public void render(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        if (this.renderOutline) {
            this.drawBorder(drawContext, this.dim.x(), this.dim.y(), this.dim.getLimitX(), this.dim.getLimitY(), -5592406);
        }
        for (Renderable drawable : this.drawable) {
            drawable.render(drawContext, mouseX, mouseY, delta);
        }
    }

    @Deprecated
    public void applyScissor(int x, int y, int width, int height, Runnable action) {
        double scale = Minecraft.getInstance().getWindow().getGuiScale();
        RenderSystem.enableScissor((int)((int)((double)x * scale)), (int)((int)((double)Minecraft.getInstance().getWindow().getHeight() - (double)(y + height) * scale)), (int)((int)((double)width * scale)), (int)((int)((double)height * scale)));
        action.run();
        RenderSystem.disableScissor();
    }

    public void registerFocusListener(Consumer<GuiEventListener> focusListener) {
        this.focusListener = focusListener;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    @Nullable
    public GuiEventListener getFocused() {
        return this.focused;
    }

    public void setFocused(@Nullable GuiEventListener focused) {
        this.focused = focused;
        if (this.focusListener != null) {
            this.focusListener.accept(focused);
        }
    }

    public List<? extends GuiEventListener> children() {
        return this.children;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.dim.containsCursor(mouseX, mouseY);
    }

    @Override
    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent navigation) {
        return super.nextFocusPath(navigation);
    }

    public ScreenRectangle getRectangle() {
        return new ScreenRectangle(this.dim.x(), this.dim.y(), this.dim.width(), this.dim.height());
    }

    public Dim2i getDimensions() {
        return this.dim;
    }
}

