/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.network.packet;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.swedz.extended_industrialization.EIText;
import net.swedz.extended_industrialization.EITooltips;
import net.swedz.extended_industrialization.item.ElectricToolItem;
import net.swedz.extended_industrialization.network.EICustomPacket;
import net.swedz.tesseract.neoforge.compat.mi.tooltip.MICompatibleTextLine;
import net.swedz.tesseract.neoforge.packet.PacketContext;
import net.swedz.tesseract.neoforge.tooltip.TranslatableTextEnum;

public record ModifyElectricToolSpeedPacket(boolean increase) implements EICustomPacket
{
    public static final StreamCodec<ByteBuf, ModifyElectricToolSpeedPacket> STREAM_CODEC = ByteBufCodecs.BOOL.map(ModifyElectricToolSpeedPacket::new, ModifyElectricToolSpeedPacket::increase);

    public void handle(PacketContext context) {
        ElectricToolItem item;
        context.assertServerbound();
        Player player = context.getPlayer();
        ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        Item item2 = stack.getItem();
        if (item2 instanceof ElectricToolItem && (item = (ElectricToolItem)item2).getToolType().hasAdjustableSpeed()) {
            int originalSpeed;
            int speed = originalSpeed = ElectricToolItem.getToolSpeed(stack);
            speed += this.increase ? 1 : -1;
            if ((speed = Mth.clamp((int)speed, (int)1, (int)10)) != originalSpeed) {
                ElectricToolItem.setToolSpeed(stack, speed);
                player.displayClientMessage((Component)MICompatibleTextLine.line((TranslatableTextEnum)EIText.TOOL_MINING_SPEED, (Style)Style.EMPTY).arg((Object)Float.valueOf((float)speed / 10.0f), EITooltips.SPACED_PERCENTAGE_PARSER.withStyle(Style.EMPTY)), true);
            }
        }
    }
}

