/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.network.packet;

import io.netty.buffer.ByteBuf;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.swedz.extended_industrialization.network.EICustomPacket;
import net.swedz.tesseract.neoforge.packet.PacketContext;

public record CatHammerPacket(int entityId) implements EICustomPacket
{
    public static final StreamCodec<ByteBuf, CatHammerPacket> STREAM_CODEC = ByteBufCodecs.VAR_INT.map(CatHammerPacket::new, CatHammerPacket::entityId);

    public void handle(PacketContext context) {
        context.assertClientbound();
        Level level = context.getPlayer().level();
        Entity entity = level.getEntity(this.entityId);
        if (entity != null) {
            Vec3 pos = entity.getEyePosition();
            Vec3 direction = entity.getViewVector(1.0f).scale(0.8);
            pos = pos.add(direction);
            pos = new Vec3(pos.x, entity.getY() + 0.1, pos.z);
            CatHammerPacket.flash((LevelAccessor)level, pos);
            for (int i = 0; i < 4; ++i) {
                CatHammerPacket.spark((LevelAccessor)level, pos);
            }
        }
    }

    private static void flash(LevelAccessor level, Vec3 pos) {
        level.addParticle((ParticleOptions)ParticleTypes.FLASH, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
    }

    private static float sparkSpeed(LevelAccessor level, boolean y) {
        RandomSource random = level.getRandom();
        return random.nextFloat() * 0.2f * (float)(y ? 1 : (random.nextBoolean() ? -1 : 1));
    }

    private static void spark(LevelAccessor level, Vec3 pos) {
        level.addParticle((ParticleOptions)ParticleTypes.FIREWORK, pos.x, pos.y, pos.z, (double)CatHammerPacket.sparkSpeed(level, false), (double)CatHammerPacket.sparkSpeed(level, true), (double)CatHammerPacket.sparkSpeed(level, false));
    }
}

