/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.guicomponent.processingarraymachineslot;

import aztech.modern_industrialization.inventory.HackySlot;
import aztech.modern_industrialization.inventory.SlotGroup;
import aztech.modern_industrialization.machines.MachineBlock;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.ElectricCraftingMachineBlockEntity;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EITags;
import net.swedz.extended_industrialization.machines.component.craft.processingarray.ProcessingArrayMachineComponent;
import net.swedz.tesseract.neoforge.helper.RegistryHelper;

public final class ProcessingArrayMachineSlot {
    public static final ResourceLocation ID = EI.id("processing_array_machine_slot");

    public static int getSlotX(MachineGuiParameters guiParameters) {
        return guiParameters.backgroundWidth + 6;
    }

    public static int getSlotY() {
        return 106 - (EI.config().allowUpgradesInProcessingArray() ? 0 : 20);
    }

    public static boolean isMachine(Item item) {
        MachineBlock machineBlock;
        BlockItem blockItem;
        Block block;
        return !RegistryHelper.holder((Registry)BuiltInRegistries.ITEM, (Object)item).is(EITags.Items.PROCESSING_ARRAY_BLACKLIST) && item instanceof BlockItem && (block = (blockItem = (BlockItem)item).getBlock()) instanceof MachineBlock && (machineBlock = (MachineBlock)block).getBlockEntityInstance() instanceof ElectricCraftingMachineBlockEntity;
    }

    public static boolean isMachine(ItemStack itemStack) {
        return ProcessingArrayMachineSlot.isMachine(itemStack.getItem());
    }

    public static ElectricCraftingMachineBlockEntity getMachine(ItemStack itemStack) {
        return (ElectricCraftingMachineBlockEntity)((MachineBlock)((BlockItem)itemStack.getItem()).getBlock()).getBlockEntityInstance();
    }

    public static final class Server
    implements GuiComponent.Server<Integer> {
        private final MachineBlockEntity machine;
        private final Supplier<Integer> getMaxMachines;
        private final ProcessingArrayMachineComponent machines;

        public Server(MachineBlockEntity machine, Supplier<Integer> getMaxMachines, ProcessingArrayMachineComponent machines) {
            this.machine = machine;
            this.getMaxMachines = getMaxMachines;
            this.machines = machines;
        }

        public Integer copyData() {
            return this.getMaxMachines.get();
        }

        public boolean needsSync(Integer cachedData) {
            return !cachedData.equals(this.getMaxMachines.get());
        }

        public void writeInitialData(RegistryFriendlyByteBuf buf) {
            this.writeCurrentData(buf);
        }

        public void writeCurrentData(RegistryFriendlyByteBuf buf) {
            buf.writeInt(this.getMaxMachines.get().intValue());
        }

        public ResourceLocation getId() {
            return ID;
        }

        public void setupMenu(GuiComponent.MenuFacade menu) {
            menu.addSlotToMenu((Slot)new HackySlot(ProcessingArrayMachineSlot.getSlotX(this.machine.guiParams), ProcessingArrayMachineSlot.getSlotY()){

                protected ItemStack getRealStack() {
                    return machines.getMachines();
                }

                protected void setRealStack(ItemStack itemStack) {
                    machines.setMachines(machine, itemStack);
                }

                public boolean mayPlace(ItemStack itemStack) {
                    return ProcessingArrayMachineSlot.isMachine(itemStack);
                }

                public int getMaxStackSize() {
                    return getMaxMachines.get();
                }
            }, SlotGroup.CONFIGURABLE_STACKS);
        }
    }
}

