/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.tesla.network.receiver;

import aztech.modern_industrialization.api.energy.CableTier;
import net.swedz.extended_industrialization.machines.component.tesla.network.TeslaNetwork;
import net.swedz.extended_industrialization.machines.component.tesla.network.TeslaNetworkPart;
import net.swedz.extended_industrialization.machines.component.tesla.network.receiver.TeslaReceiverState;
import net.swedz.extended_industrialization.machines.component.tesla.network.transmitter.TeslaTransmitter;
import net.swedz.tesseract.neoforge.api.WorldPos;

public interface TeslaReceiver
extends TeslaNetworkPart,
Comparable<TeslaReceiver> {
    default public boolean isMobile() {
        return false;
    }

    default public int getPriority() {
        return 0;
    }

    @Override
    default public int compareTo(TeslaReceiver other) {
        return Integer.compare(other.getPriority(), this.getPriority());
    }

    default public TeslaReceiverState checkReceiveFrom(TeslaNetwork network) {
        WorldPos receiverPos;
        TeslaTransmitter transmitter = network.getTransmitter();
        if (transmitter.isInterdimensional()) {
            return TeslaReceiverState.SUCCESS;
        }
        WorldPos transmitterPos = transmitter.getSourcePosition();
        if (!transmitterPos.isSameDimension(receiverPos = this.getSourcePosition())) {
            return TeslaReceiverState.TOO_FAR;
        }
        int maxDistance = network.getMaxDistance();
        int distX = Math.abs(transmitterPos.getX() - receiverPos.getX());
        int distY = Math.abs(transmitterPos.getY() - receiverPos.getY());
        int distZ = Math.abs(transmitterPos.getZ() - receiverPos.getZ());
        if (distX > maxDistance || distY > maxDistance || distZ > maxDistance) {
            return TeslaReceiverState.TOO_FAR;
        }
        return TeslaReceiverState.SUCCESS;
    }

    public long receiveEnergy(long var1, boolean var3);

    public long getStoredEnergy();

    public long getEnergyCapacity();

    public static interface Delegate
    extends TeslaReceiver {
        public TeslaReceiver getDelegateReceiver();

        @Override
        default public TeslaReceiverState checkReceiveFrom(TeslaNetwork network) {
            return this.getDelegateReceiver().checkReceiveFrom(network);
        }

        @Override
        default public boolean hasNetwork() {
            return this.getDelegateReceiver().hasNetwork();
        }

        @Override
        default public WorldPos getNetworkKey() {
            return this.getDelegateReceiver().getNetworkKey();
        }

        @Override
        default public void setNetwork(WorldPos key) {
            this.getDelegateReceiver().setNetwork(key);
        }

        @Override
        default public WorldPos getPosition() {
            return this.getDelegateReceiver().getPosition();
        }

        @Override
        default public WorldPos getSourcePosition() {
            return this.getDelegateReceiver().getSourcePosition();
        }

        @Override
        default public CableTier getCableTier() {
            return this.getDelegateReceiver().getCableTier();
        }

        @Override
        default public long receiveEnergy(long maxReceive, boolean simulate) {
            return this.getDelegateReceiver().receiveEnergy(maxReceive, simulate);
        }

        @Override
        default public long getStoredEnergy() {
            return this.getDelegateReceiver().getStoredEnergy();
        }

        @Override
        default public long getEnergyCapacity() {
            return this.getDelegateReceiver().getEnergyCapacity();
        }
    }
}

