/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.blockentity.brewery;

import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.components.OverclockComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.guicomponents.GunpowderOverclockGui;
import aztech.modern_industrialization.machines.helper.SteamHelper;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.util.Simulation;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.machines.blockentity.brewery.BreweryMachineBlockEntity;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.MachineGuiConfiguration;

public final class SteamBreweryMachineBlockEntity
extends BreweryMachineBlockEntity {
    private final OverclockComponent overclockComponent;

    public SteamBreweryMachineBlockEntity(BEP bep, MachineGuiConfiguration gui, boolean bronze) {
        super(bep, bronze ? MachineTier.BRONZE : MachineTier.STEEL, gui.createGuiParams(EI.id((bronze ? "bronze" : "steel") + "_brewery")), gui.buildInventory());
        gui.registerProgressBar((MachineBlockEntity)this, () -> ((CrafterComponent)this.crafter).getProgress());
        this.overclockComponent = new OverclockComponent(OverclockComponent.getDefaultCatalysts());
        GunpowderOverclockGui.Parameters gunpowderOverclockGuiParams = new GunpowderOverclockGui.Parameters(gui.getProgressBar().renderX, gui.getProgressBar().renderY + 20);
        GuiComponent.Server[] serverArray = new GuiComponent.Server[1];
        serverArray[0] = new GunpowderOverclockGui.Server(gunpowderOverclockGuiParams, () -> ((OverclockComponent)this.overclockComponent).getTicks());
        this.registerGuiComponent(serverArray);
        this.registerComponents(new IComponent[]{this.overclockComponent});
    }

    public long consumeEu(long max, Simulation simulation) {
        return SteamHelper.consumeSteamEu((List)this.inventory.getFluidInputs(), (long)max, (Simulation)simulation);
    }

    @Override
    public long getMaxRecipeEu() {
        return this.overclockComponent.getRecipeEu(this.tier.getMaxEu());
    }

    @Override
    public long getBaseRecipeEu() {
        return this.overclockComponent.getRecipeEu(this.tier.getBaseEu());
    }

    @Override
    public List<Component> getTooltips() {
        ArrayList tooltips = Lists.newArrayList();
        tooltips.addAll(this.overclockComponent.getTooltips());
        tooltips.addAll(super.getTooltips());
        return tooltips;
    }

    @Override
    public void tick() {
        super.tick();
        this.overclockComponent.tick((MachineBlockEntity)this);
    }

    protected ItemInteractionResult useItemOn(Player player, InteractionHand hand, Direction face) {
        ItemInteractionResult result = super.useItemOn(player, hand, face);
        if (!result.consumesAction()) {
            return this.overclockComponent.onUse((MachineBlockEntity)this, player, hand);
        }
        return result;
    }
}

