/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.item.machineconfig;

import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.util.Simulation;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.swedz.extended_industrialization.item.machineconfig.MachineConfigApplicable;

record MachineConfigOrientation(Direction facingDirection, boolean hasOutput, Direction outputDirection, boolean extractItems, boolean extractFluids) implements MachineConfigApplicable<OrientationComponent>
{
    public static final Codec<MachineConfigOrientation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Direction.CODEC.fieldOf("facing_direction").forGetter(MachineConfigOrientation::facingDirection), (App)Codec.BOOL.fieldOf("has_output").forGetter(MachineConfigOrientation::hasOutput), (App)Direction.CODEC.optionalFieldOf("output_direction").forGetter(o -> Optional.ofNullable(o.outputDirection())), (App)Codec.BOOL.fieldOf("extract_items").forGetter(MachineConfigOrientation::extractItems), (App)Codec.BOOL.fieldOf("extract_fluids").forGetter(MachineConfigOrientation::extractFluids)).apply((Applicative)instance, (facingDirection, hasOutput, outputDirection, extractItems, extractFluids) -> new MachineConfigOrientation((Direction)facingDirection, (boolean)hasOutput, outputDirection.orElse(null), (boolean)extractItems, (boolean)extractFluids)));

    public static MachineConfigOrientation from(OrientationComponent component) {
        return new MachineConfigOrientation(component.facingDirection, component.params.hasOutput, component.outputDirection, component.extractItems, component.extractFluids);
    }

    @Override
    public boolean matches(OrientationComponent target) {
        return this.hasOutput == target.params.hasOutput;
    }

    @Override
    public boolean apply(Player player, OrientationComponent target, Simulation simulation) {
        if (!this.matches(target)) {
            return false;
        }
        if (simulation.isActing()) {
            target.facingDirection = this.facingDirection;
            if (target.params.hasOutput) {
                target.outputDirection = this.outputDirection;
                target.extractItems = this.extractItems;
                target.extractFluids = this.extractFluids;
            }
        }
        return true;
    }
}

