/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.entity;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.swedz.extended_industrialization.EIDamageTypes;
import net.swedz.extended_industrialization.EIEntities;
import net.swedz.extended_industrialization.EISounds;
import net.swedz.tesseract.neoforge.api.tuple.Pair;

public final class NanoSaberSweepEntity
extends Projectile {
    private static final EntityDataAccessor<Integer> DATA_COLOR = SynchedEntityData.defineId(NanoSaberSweepEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_RAINBOW = SynchedEntityData.defineId(NanoSaberSweepEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private long ticks;
    private int color;
    private boolean rainbow;
    private float power;
    private boolean beheading;

    public NanoSaberSweepEntity(EntityType<? extends NanoSaberSweepEntity> type, Level level) {
        super(type, level);
    }

    public NanoSaberSweepEntity(Level level, LivingEntity owner, Vec3 movement, int color, boolean rainbow, float power, boolean beheading) {
        super(EIEntities.NANO_SABER_SWEEP.get(), level);
        this.setOwner((Entity)owner);
        this.setDeltaMovement(movement.normalize().multiply(3.0, 3.0, 3.0));
        this.setColor(color);
        this.setRainbow(rainbow);
        this.setPower(power);
        this.setBeheading(beheading);
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
        this.entityData.set(DATA_COLOR, (Object)color);
    }

    public boolean isRainbow() {
        return this.rainbow;
    }

    public void setRainbow(boolean rainbow) {
        this.rainbow = rainbow;
        this.entityData.set(DATA_RAINBOW, (Object)rainbow);
    }

    public float getPower() {
        return this.power;
    }

    public void setPower(float power) {
        this.power = Math.max(0.0f, power);
    }

    public boolean isBeheading() {
        return this.beheading;
    }

    public void setBeheading(boolean beheading) {
        this.beheading = beheading;
    }

    public boolean isOnFire() {
        return false;
    }

    private static Pair<BlockHitResult, List<Entity>> getHitResult(Projectile projectile, ClipContext.Block context, Predicate<Entity> filter) {
        Vec3 movement = projectile.getDeltaMovement();
        Vec3 start = projectile.position();
        Vec3 end = start.add(movement);
        return new Pair((Object)projectile.level().clip(new ClipContext(start, end, context, ClipContext.Fluid.ANY, (Entity)projectile)), NanoSaberSweepEntity.getEntityHitResult((Entity)projectile, projectile.getBoundingBox().expandTowards(movement), filter));
    }

    private static List<Entity> getEntityHitResult(Entity projectile, AABB boundingBox, Predicate<Entity> filter) {
        return projectile.level().getEntities(projectile, boundingBox, filter);
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        if (this.ticks >= 200L) {
            this.discard();
            level.playSound(null, this.blockPosition(), EISounds.NANO_SABER_SWEEP_EXTINGUISH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            return;
        }
        Entity owner = this.getOwner();
        if (level.isClientSide() || (owner == null || !owner.isRemoved()) && level.hasChunkAt(this.blockPosition())) {
            Pair<BlockHitResult, List<Entity>> hitResult = NanoSaberSweepEntity.getHitResult(this, ClipContext.Block.COLLIDER, x$0 -> this.canHitEntity((Entity)x$0));
            BlockHitResult blockHitResult = (BlockHitResult)hitResult.a();
            if (blockHitResult.getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)blockHitResult)) {
                this.hitTargetOrDeflectSelf((HitResult)blockHitResult);
            }
            for (Entity hitEntity : (List)hitResult.b()) {
                this.hitTargetOrDeflectSelf((HitResult)new EntityHitResult(hitEntity));
            }
            this.checkInsideBlocks();
            this.setPos(this.position().add(this.getDeltaMovement()));
        } else {
            this.discard();
            level.playSound(null, this.blockPosition(), EISounds.NANO_SABER_SWEEP_EXTINGUISH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        ++this.ticks;
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            Entity hitEntity = result.getEntity();
            level2.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, hitEntity.getX(), hitEntity.getY(), hitEntity.getZ(), 10, 0.1, 0.1, 0.1, 0.1);
            Entity entity = this.getOwner();
            if (entity instanceof LivingEntity) {
                LivingEntity owner = (LivingEntity)entity;
                DamageSource source = EIDamageTypes.nanoSweep((Level)level2, this, (Entity)owner, this.beheading);
                hitEntity.hurt(source, this.power);
                if (hitEntity.isAlive()) {
                    EnchantmentHelper.doPostAttackEffects((ServerLevel)level2, (Entity)hitEntity, (DamageSource)source);
                }
            }
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            this.discard();
            Vec3 hitPos = result.getLocation();
            level2.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, hitPos.x(), hitPos.y(), hitPos.z(), 10, 0.1, 0.1, 0.1, 0.1);
            level2.playSound(null, this.blockPosition(), EISounds.NANO_SABER_SWEEP_EXTINGUISH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        int data = this.color & 0xFFFFFF | (this.rainbow ? 1 : 0) << 24;
        return new ClientboundAddEntityPacket((Entity)this, serverEntity, data);
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        int data = packet.getData();
        this.setColor(data & 0xFFFFFF);
        this.setRainbow((data >> 24 & 1) != 0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_COLOR, (Object)this.color);
        builder.define(DATA_RAINBOW, (Object)this.rainbow);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (key.equals(DATA_COLOR)) {
            this.color = (Integer)this.entityData.get(DATA_COLOR);
        } else if (key.equals(DATA_RAINBOW)) {
            this.rainbow = (Boolean)this.entityData.get(DATA_RAINBOW);
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putLong("Ticks", this.ticks);
        tag.putInt("Color", this.color);
        tag.putBoolean("Rainbow", this.rainbow);
        tag.putFloat("Power", this.power);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.ticks = tag.getLong("Ticks");
        this.setColor(tag.getInt("Color"));
        this.setRainbow(tag.getBoolean("Rainbow"));
        this.setPower(tag.getFloat("Power"));
    }
}

