/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization;

import aztech.modern_industrialization.definition.FluidTexture;
import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EIBlocks;
import net.swedz.extended_industrialization.EIItems;
import net.swedz.extended_industrialization.EISortOrder;
import net.swedz.extended_industrialization.EITags;
import net.swedz.tesseract.neoforge.registry.MIFluidProperties;
import net.swedz.tesseract.neoforge.registry.holder.FluidHolder;
import net.swedz.tesseract.neoforge.registry.holder.MIFluidHolder;

public final class EIFluids {
    public static final MIFluidHolder HONEY = (MIFluidHolder)((FluidHolder)EIFluids.create("honey", "Honey", 15904289, 240, FluidTexture.WATER_LIKE, false).tag(new TagKey[]{EITags.Fluids.HONEY})).register();
    public static final MIFluidHolder MANURE = EIFluids.create("manure", "Manure", 2167812, 255, FluidTexture.LAVA_LIKE, false).register();
    public static final MIFluidHolder COMPOSTED_MANURE = EIFluids.create("composted_manure", "Composted Manure", 3152640, 255, FluidTexture.LAVA_LIKE, false).register();
    public static final MIFluidHolder PHOSPHORIC_ACID = EIFluids.create("phosphoric_acid", "Phosphoric Acid", 40960, 240, FluidTexture.WATER_LIKE, false).register();
    public static final MIFluidHolder POTASSIUM_CHLORIDE = EIFluids.create("potassium_chloride", "Potassium Chloride", 0xCECECE, 240, FluidTexture.WATER_LIKE, false).register();
    public static final MIFluidHolder POTASSIUM_HYDROXIDE = EIFluids.create("potassium_hydroxide", "Potassium Hydroxide", 14135043, 180, FluidTexture.WATER_LIKE, false).register();
    public static final MIFluidHolder NPK_FERTILIZER = EIFluids.create("npk_fertilizer", "NPK Fertilizer", 4898116, 240, FluidTexture.WATER_LIKE, false).register();
    public static final MIFluidHolder DISTILLED_WATER = EIFluids.create("distilled_water", "Distilled Water", 11390463, 180, FluidTexture.WATER_LIKE, false).register();
    public static final MIFluidHolder BLAZING_ESSENCE = EIFluids.create("blazing_essence", "Blazing Essence", 16767298, 240, FluidTexture.LAVA_LIKE, true).register();

    public static void init(IEventBus bus) {
        Registry.init(bus);
    }

    public static Set<FluidHolder> values() {
        return Set.copyOf(Registry.HOLDERS);
    }

    public static MIFluidHolder create(String id, String englishName, MIFluidProperties properties) {
        MIFluidHolder holder = new MIFluidHolder(EI.id(id), englishName, Registry.FLUIDS, Registry.FLUID_TYPES, EIBlocks.Registry.BLOCKS, EIItems.Registry.ITEMS, EISortOrder.BUCKETS, properties);
        Registry.include((FluidHolder)holder);
        EIBlocks.Registry.include(holder.block());
        EIItems.Registry.include(holder.bucketItem());
        return holder;
    }

    public static MIFluidHolder create(String id, String englishName, int color, int opacity, FluidTexture texture, boolean isGas) {
        return EIFluids.create(id, englishName, new MIFluidProperties(color, opacity, texture, isGas));
    }

    public static final class Registry {
        public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((ResourceKey)Registries.FLUID, (String)"extended_industrialization");
        public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((net.minecraft.core.Registry)NeoForgeRegistries.FLUID_TYPES, (String)"extended_industrialization");
        private static final Set<FluidHolder> HOLDERS = Sets.newHashSet();

        private static void init(IEventBus bus) {
            FLUIDS.register(bus);
            FLUID_TYPES.register(bus);
        }

        public static void include(FluidHolder holder) {
            HOLDERS.add(holder);
        }
    }
}

