/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization;

import aztech.modern_industrialization.machines.MachineBlock;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.MachineBlockEntityRenderer;
import aztech.modern_industrialization.machines.blockentities.multiblocks.LargeTankMultiblockBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBER;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.MultiblockTankBER;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterMaterialAtlasesEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EIBlocks;
import net.swedz.extended_industrialization.EIClientConfig;
import net.swedz.extended_industrialization.EIClientSheets;
import net.swedz.extended_industrialization.EIEntities;
import net.swedz.extended_industrialization.EIItems;
import net.swedz.extended_industrialization.EIKeybinds;
import net.swedz.extended_industrialization.client.NanoGravichestplateHudRenderer;
import net.swedz.extended_industrialization.client.ber.chainer.MachineChainerHighlightRenderer;
import net.swedz.extended_industrialization.client.ber.tesla.TeslaPartMultiblockRenderer;
import net.swedz.extended_industrialization.client.ber.tesla.TeslaPartSingleBlockRenderer;
import net.swedz.extended_industrialization.client.ber.tesla.behavior.TeslaBehavior;
import net.swedz.extended_industrialization.client.entity.NanoSaberSweepEntityRenderer;
import net.swedz.extended_industrialization.client.model.chainer.MachineChainerUnbakedModel;
import net.swedz.extended_industrialization.client.model.tesla.TeslaParticleGeneratorModel;
import net.swedz.extended_industrialization.client.model.tesla.TeslaUnbakedModel;
import net.swedz.extended_industrialization.item.ElectricToolItem;
import net.swedz.extended_industrialization.item.SteamChainsawItem;
import net.swedz.extended_industrialization.item.tooltip.SteamChainsawTooltipComponent;
import net.swedz.extended_industrialization.machines.blockentity.MachineChainerMachineBlockEntity;
import net.swedz.extended_industrialization.network.packet.ModifyElectricToolSpeedPacket;
import net.swedz.tesseract.neoforge.api.Assert;
import net.swedz.tesseract.neoforge.config.ConfigManager;
import net.swedz.tesseract.neoforge.item.DynamicDyedItem;
import net.swedz.tesseract.neoforge.registry.RegisteredObjectHolder;

@Mod(value="extended_industrialization", dist={Dist.CLIENT})
@EventBusSubscriber(value={Dist.CLIENT}, modid="extended_industrialization", bus=EventBusSubscriber.Bus.MOD)
public final class EIClient {
    private static EIClientConfig CONFIG;

    public EIClient(IEventBus bus, ModContainer container) {
        EIClient.setupConfig(bus, container);
        EIKeybinds.init(bus);
        NeoForge.EVENT_BUS.addListener(ClientTickEvent.Post.class, event -> {
            for (EIKeybinds.Keybind keybind : EIKeybinds.Registry.getMappings()) {
                while (((KeyMapping)keybind.holder().get()).consumeClick()) {
                    keybind.action().run();
                }
            }
        });
        NeoForge.EVENT_BUS.addListener(InputEvent.MouseScrollingEvent.class, event -> {
            ElectricToolItem tool;
            LocalPlayer player;
            ItemStack stack;
            Item patt0$temp;
            if (Screen.hasAltDown() && (patt0$temp = (stack = (player = Minecraft.getInstance().player).getItemInHand(InteractionHand.MAIN_HAND)).getItem()) instanceof ElectricToolItem && (tool = (ElectricToolItem)patt0$temp).getToolType().hasAdjustableSpeed()) {
                boolean increase = event.getScrollDeltaY() > 0.0;
                int speed = ElectricToolItem.getToolSpeed(stack);
                if (increase ? speed < 10 : speed > 1) {
                    new ModifyElectricToolSpeedPacket(increase).sendToServer();
                }
                event.setCanceled(true);
            }
        });
    }

    public static EIClientConfig config() {
        Assert.notNull((Object)CONFIG, (String)"Config not yet loaded");
        return CONFIG;
    }

    private static void setupConfig(IEventBus bus, ModContainer container) {
        CONFIG = (EIClientConfig)new ConfigManager().includeDefaultValueComments().build(EIClientConfig.class).register(container, ModConfig.Type.CLIENT).listenToLoad(bus).config();
    }

    @SubscribeEvent
    private static void registerItemProperties(FMLClientSetupEvent event) {
        event.enqueueWork(() -> EIItems.values().forEach(RegisteredObjectHolder::triggerClientRegistrationListener));
    }

    @SubscribeEvent
    private static void onRegisterColorItems(RegisterColorHandlersEvent.Item event) {
        event.register((stack, color) -> color > 0 ? -1 : DyedItemColor.getOrDefault((ItemStack)stack, (int)((DynamicDyedItem)stack.getItem()).getDefaultDyeColor()), new ItemLike[]{EIItems.NANO_SABER, EIItems.ULTIMATE_LASER_DRILL, EIItems.NANO_HELMET, EIItems.NANO_CHESTPLATE, EIItems.NANO_GRAVICHESTPLATE, EIItems.NANO_LEGGINGS, EIItems.NANO_BOOTS, EIItems.NANO_QUANTUM_HELMET, EIItems.NANO_QUANTUM_CHESTPLATE, EIItems.NANO_QUANTUM_LEGGINGS, EIItems.NANO_QUANTUM_BOOTS});
        event.register((stack, color) -> color == 0 || color == 2 ? DyedItemColor.getOrDefault((ItemStack)stack, (int)((DynamicDyedItem)stack.getItem()).getDefaultDyeColor()) : -1, new ItemLike[]{EIItems.NANO_QUANTUM_SABER});
    }

    @SubscribeEvent
    private static void registerModelLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register(MachineChainerUnbakedModel.LOADER_ID, MachineChainerUnbakedModel.LOADER);
        event.register(TeslaUnbakedModel.LOADER_ID, TeslaUnbakedModel.LOADER);
        event.register(TeslaParticleGeneratorModel.LOADER_ID, TeslaParticleGeneratorModel.LOADER);
    }

    @SubscribeEvent
    private static void registerBlockEntityRenderers(FMLClientSetupEvent event) {
        for (DeferredHolder blockDef : EIBlocks.Registry.BLOCKS.getEntries()) {
            Object object = blockDef.get();
            if (!(object instanceof MachineBlock)) continue;
            MachineBlock machine = (MachineBlock)object;
            try {
                MachineBlockEntity machineBlockEntity;
                MachineBlockEntity blockEntity = machine.getBlockEntityInstance();
                BlockEntityType type = blockEntity.getType();
                Objects.requireNonNull(blockEntity);
                int n = 0;
                BlockEntityRendererProvider provider = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MachineChainerMachineBlockEntity.class, TeslaBehavior.class, LargeTankMultiblockBlockEntity.class, MultiblockMachineBlockEntity.class}, (Object)machineBlockEntity, n)) {
                    case 0 -> {
                        MachineChainerMachineBlockEntity be = (MachineChainerMachineBlockEntity)machineBlockEntity;
                        yield MachineChainerHighlightRenderer::new;
                    }
                    case 1 -> {
                        MachineBlockEntity var12_13;
                        TeslaBehavior __ = (TeslaBehavior)machineBlockEntity;
                        Objects.requireNonNull(blockEntity);
                        int var13_14 = 0;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MultiblockMachineBlockEntity.class}, (Object)var12_13, var13_14)) {
                            case 0: {
                                MultiblockMachineBlockEntity be = (MultiblockMachineBlockEntity)var12_13;
                                yield TeslaPartMultiblockRenderer::new;
                            }
                        }
                        yield TeslaPartSingleBlockRenderer::new;
                    }
                    case 2 -> {
                        LargeTankMultiblockBlockEntity be = (LargeTankMultiblockBlockEntity)machineBlockEntity;
                        yield MultiblockTankBER::new;
                    }
                    case 3 -> {
                        MultiblockMachineBlockEntity be = (MultiblockMachineBlockEntity)machineBlockEntity;
                        yield MultiblockMachineBER::new;
                    }
                    default -> MachineBlockEntityRenderer::new;
                };
                BlockEntityRenderers.register((BlockEntityType)type, (BlockEntityRendererProvider)provider);
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to register BER for %s".formatted(blockDef.getId()), ex);
            }
        }
    }

    @SubscribeEvent
    private static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(EIEntities.NANO_SABER_SWEEP.get(), NanoSaberSweepEntityRenderer::new);
    }

    @SubscribeEvent
    private static void registerClientTooltipComponents(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(SteamChainsawItem.SteamChainsawTooltipData.class, SteamChainsawTooltipComponent::new);
    }

    @SubscribeEvent
    private static void registerGuiLayers(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.SELECTED_ITEM_NAME, EI.id("nano_gravichestplate_activation_status"), NanoGravichestplateHudRenderer::render);
    }

    @SubscribeEvent
    private static void registerAdditionalModels(ModelEvent.RegisterAdditional event) {
        event.register(ModelResourceLocation.standalone((ResourceLocation)EI.id("tesla/lethal_tesla_coil")));
        event.register(ModelResourceLocation.standalone((ResourceLocation)EI.id("tesla/tesla_coil")));
        event.register(ModelResourceLocation.standalone((ResourceLocation)EI.id("tesla/tesla_particle_generator/small")));
        event.register(ModelResourceLocation.standalone((ResourceLocation)EI.id("tesla/tesla_particle_generator/medium")));
        event.register(ModelResourceLocation.standalone((ResourceLocation)EI.id("tesla/tesla_particle_generator/large")));
        event.register(ModelResourceLocation.standalone((ResourceLocation)EI.id("tesla/tesla_particle_generator/extreme")));
        event.register(ModelResourceLocation.standalone((ResourceLocation)EI.id("tesla/tesla_particle_generator/immense")));
        event.register(ModelResourceLocation.standalone((ResourceLocation)EI.id("tesla/tesla_hatch")));
        event.register(ModelResourceLocation.standalone((ResourceLocation)EI.id("tesla/tesla_receiver")));
        event.register(ModelResourceLocation.standalone((ResourceLocation)EI.id("tesla/tesla_tower")));
        event.register(ModelResourceLocation.standalone((ResourceLocation)EI.id("entity/nano_saber_sweep")));
    }

    @SubscribeEvent
    private static void registerAtlases(RegisterMaterialAtlasesEvent event) {
        event.register(EIClientSheets.NANO_SABER_SWEEP, EI.id("nano_saber_sweep"));
    }
}

