/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.util;

import com.google.common.collect.ImmutableMap;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.block.Furnace;
import xiroc.dungeoncrawl.dungeon.block.Plants;
import xiroc.dungeoncrawl.dungeon.block.Spawner;
import xiroc.dungeoncrawl.theme.SecondaryTheme;
import xiroc.dungeoncrawl.theme.Theme;

public interface IBlockPlacementHandler {
    public static final IBlockPlacementHandler SPAWNER = new Spawner();
    public static final IBlockPlacementHandler DEFAULT = (world, state, pos, rand, theme, secondaryTheme, lootLevel) -> {
        if (((Boolean)Config.TICK_FALLING_BLOCKS.get()).booleanValue() && state.getBlock() instanceof FallingBlock) {
            world.scheduleTick(pos, state.getBlock(), 1);
        }
        world.setBlock(pos, state, 2);
    };
    public static final ImmutableMap<Block, IBlockPlacementHandler> PLACEMENT_HANDLERS = new ImmutableMap.Builder().put((Object)Blocks.FURNACE, (Object)new Furnace()).put((Object)Blocks.SMOKER, (Object)new Furnace.Smoker()).put((Object)Blocks.SPAWNER, (Object)SPAWNER).put((Object)Blocks.FARMLAND, (Object)new Plants.Farmland()).put((Object)Blocks.FLOWER_POT, (Object)new Plants.FlowerPot()).put((Object)Blocks.PODZOL, (Object)new Plants.Podzol()).build();

    public void place(LevelAccessor var1, BlockState var2, BlockPos var3, RandomSource var4, Theme var5, SecondaryTheme var6, int var7);

    public static IBlockPlacementHandler getHandler(Block block) {
        return (IBlockPlacementHandler)PLACEMENT_HANDLERS.getOrDefault((Object)block, (Object)DEFAULT);
    }
}

