/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.block;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.monster.RandomEquipment;
import xiroc.dungeoncrawl.dungeon.monster.RandomMonster;
import xiroc.dungeoncrawl.dungeon.monster.RandomPotionEffect;
import xiroc.dungeoncrawl.dungeon.monster.SpawnRates;
import xiroc.dungeoncrawl.dungeon.treasure.RandomItems;
import xiroc.dungeoncrawl.theme.SecondaryTheme;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.IBlockPlacementHandler;
import xiroc.dungeoncrawl.util.Range;

public class Spawner
implements IBlockPlacementHandler {
    public static final Set<EntityType<?>> INVENTORY_ENTITIES = ImmutableSet.builder().add((Object)EntityType.ZOMBIE).add((Object)EntityType.SKELETON).add((Object)EntityType.HUSK).add((Object)EntityType.STRAY).add((Object)EntityType.WITHER_SKELETON).build();
    public static final Set<EntityType<?>> RANGED_INVENTORY_ENTITIES = ImmutableSet.builder().add((Object)EntityType.SKELETON).add((Object)EntityType.STRAY).build();

    @Override
    public void place(LevelAccessor world, BlockState state, BlockPos pos, RandomSource rand, Theme theme, SecondaryTheme secondaryTheme, int stage) {
        world.setBlock(pos, Blocks.SPAWNER.defaultBlockState(), 2);
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity spawner = (SpawnerBlockEntity)tile;
            EntityType<?> type = RandomMonster.randomMonster(rand, stage);
            spawner.getSpawner().setEntityId(type, null, rand, pos);
            if (((Boolean)Config.CUSTOM_SPAWNERS.get()).booleanValue() && INVENTORY_ENTITIES.contains(type)) {
                CompoundTag spawnerNBT = spawner.getSpawner().save(new CompoundTag());
                ListTag potentialSpawns = new ListTag();
                for (int i = 0; i < (Integer)Config.SPAWNER_ENTITIES.get(); ++i) {
                    CompoundTag potentialSpawn = new CompoundTag();
                    CompoundTag data = new CompoundTag();
                    CompoundTag spawnData = Spawner.createSpawnData(type, null, rand, stage, world.registryAccess());
                    data.put("entity", (Tag)spawnData);
                    potentialSpawn.put("data", (Tag)data);
                    potentialSpawn.putInt("weight", 1);
                    if (i == 0) {
                        spawnerNBT.put("SpawnData", (Tag)data);
                    }
                    potentialSpawns.add((Object)potentialSpawn);
                }
                Range delay = SpawnRates.getDelay(stage);
                spawnerNBT.put("SpawnPotentials", (Tag)potentialSpawns);
                spawnerNBT.putShort("MinSpawnDelay", (short)delay.min());
                spawnerNBT.putShort("MaxSpawnDelay", (short)delay.max());
                spawnerNBT.putShort("SpawnCount", (short)SpawnRates.getAmount(stage).nextInt(rand));
                spawnerNBT.putShort("RequiredPlayerRange", ((Integer)Config.SPAWNER_RANGE.get()).shortValue());
                spawner.getSpawner().load(spawner.getLevel(), pos, spawnerNBT);
            }
        } else {
            DungeonCrawl.LOGGER.error("Failed to fetch a mob spawner at ({}, {}, {})", (Object)pos.getX(), (Object)pos.getY(), (Object)pos.getZ());
        }
    }

    public static CompoundTag createSpawnData(@Nullable EntityType<?> type, @Nullable CompoundTag spawnData, RandomSource rand, int stage, RegistryAccess registryAccess) {
        if (type == null) {
            type = RandomMonster.randomMonster(rand, stage);
        }
        if (spawnData == null) {
            spawnData = new CompoundTag();
        }
        ResourceLocation registryName = BuiltInRegistries.ENTITY_TYPE.getKey(type);
        spawnData.putString("id", registryName.toString());
        if (INVENTORY_ENTITIES.contains(type)) {
            ListTag potionEffects;
            ItemStack mainHand;
            ItemStack[] armor = RandomEquipment.createArmor(rand, stage, registryAccess);
            ListTag armorList = new ListTag();
            for (ItemStack stack : armor) {
                if (stack.isEmpty()) {
                    armorList.add((Object)new CompoundTag());
                    continue;
                }
                armorList.add((Object)stack.save((HolderLookup.Provider)registryAccess));
            }
            spawnData.put("ArmorItems", (Tag)armorList);
            ListTag handItems = new ListTag();
            ItemStack itemStack = mainHand = RANGED_INVENTORY_ENTITIES.contains(type) ? RandomEquipment.getRangedWeapon(rand, stage, registryAccess) : RandomEquipment.getMeleeWeapon(rand, stage, registryAccess);
            if (mainHand.isEmpty()) {
                handItems.add((Object)new CompoundTag());
            } else {
                handItems.add((Object)mainHand.save((HolderLookup.Provider)registryAccess));
            }
            if (rand.nextDouble() < 0.25) {
                handItems.add((Object)RandomItems.createShield(rand, stage, registryAccess).save((HolderLookup.Provider)registryAccess));
            } else {
                handItems.add((Object)new CompoundTag());
            }
            spawnData.put("HandItems", (Tag)handItems);
            if (!((Boolean)Config.NATURAL_DESPAWN.get()).booleanValue()) {
                spawnData.putBoolean("PersistenceRequired", true);
            }
            if ((potionEffects = RandomPotionEffect.createPotionEffects(rand, stage)) != null) {
                spawnData.put("active_effects", (Tag)potionEffects);
            }
        }
        if (((Boolean)Config.OVERWRITE_ENTITY_LOOT_TABLES.get()).booleanValue() && RandomMonster.NBT_PATCHERS.containsKey(type)) {
            RandomMonster.NBT_PATCHERS.get(type).patch(spawnData, rand, stage);
        }
        return spawnData;
    }
}

