/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.datagen;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.components.MGUComponents;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.neoforge.registries.DeferredHolder;

public class MGULootTables
extends BlockLootSubProvider {
    protected MGULootTables(HolderLookup.Provider registries) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
    }

    public static LootTableProvider getProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> future) {
        return new LootTableProvider(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(MGULootTables::new, LootContextParamSets.BLOCK)), future);
    }

    protected void generate() {
        CopyComponentsFunction.Builder copyFluid = CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(MGUComponents.FLUID.get());
        this.dropComponents(ModBlocks.TANK, $ -> $.apply((LootItemFunction.Builder)copyFluid));
        this.dropComponents(ModBlocks.TANK_SINK, $ -> $.apply((LootItemFunction.Builder)copyFluid));
        this.dropComponents(ModBlocks.JUMBO_TANK, $ -> $.apply((LootItemFunction.Builder)copyFluid));
        this.dropComponents(ModBlocks.XPSOLIDIFIER, $ -> $.apply((LootItemFunction.Builder)copyFluid));
        this.dropSelf((Block)ModBlocks.ABSORPTION_HOPPER.getBlock());
        this.dropSelf(ModBlocks.DARK_OAK_STONE.getBlock());
        this.dropSelf(ModBlocks.DRAGON_MUFFLER.getBlock());
        this.dropSelf(ModBlocks.WITHER_MUFFLER.getBlock());
        this.dropSelf(ModBlocks.ENTITY_CONVEYOR.getBlock());
        this.dropSelf((Block)ModBlocks.FAN.getBlock());
        this.dropSelf((Block)ModBlocks.SAW.getBlock());
        this.dropSelf((Block)ModBlocks.SPIKES.getBlock());
        this.dropSelf((Block)ModBlocks.XP_TAP.getBlock());
        this.dropSelf(ModBlocks.ENDER_INHIBITOR_ON.getBlock());
        this.dropOther(ModBlocks.ENDER_INHIBITOR_OFF.getBlock(), (ItemLike)ModBlocks.ENDER_INHIBITOR_ON.getItem());
        this.dropSelf(ModBlocks.TINTED_GLASS.getBlock());
        this.add(ModBlocks.DREADFUL_DIRT.getBlock(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Items.DIRT));
        this.add(ModBlocks.DELIGHTFUL_DIRT.getBlock(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Items.DIRT));
        this.dropSelf((Block)ModBlocks.SOLID_XP_BLOCK.getBlock());
        this.dropSelf(ModBlocks.ENTITY_SPAWNER.getBlock());
    }

    private void dropComponents(Supplier<? extends Block> blockSupplier, Consumer<LootPool.Builder> lootFunctionSupplier) {
        LootPool.Builder lootPool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)blockSupplier.get())));
        lootFunctionSupplier.accept(lootPool);
        this.add(blockSupplier.get(), LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)blockSupplier.get(), (ConditionUserBuilder)lootPool)));
    }

    @Nonnull
    protected Iterable<Block> getKnownBlocks() {
        ImmutableSet ignoreList = ImmutableSet.of((Object)((Block)ModBlocks.FLUID_XP_BLOCK.get()));
        return ModBlocks.BLOCKS.getEntries().stream().map(DeferredHolder::get).filter(arg_0 -> MGULootTables.lambda$getKnownBlocks$6((Set)ignoreList, arg_0)).collect(Collectors.toList());
    }

    private static /* synthetic */ boolean lambda$getKnownBlocks$6(Set ignoreList, Block e) {
        return !ignoreList.contains(e);
    }
}

