/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.blocks;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockEntityConveyor
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final VoxelShape CONVEYOR_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);

    public BlockEntityConveyor(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return CONVEYOR_AABB;
    }

    @Nonnull
    public VoxelShape getInteractionShape(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos) {
        return Shapes.block();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection().getOpposite();
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public void entityInside(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, Entity entity) {
        if (entity.isShiftKeyDown()) {
            return;
        }
        if (entity instanceof Mob) {
            ((Mob)entity).setPersistenceRequired();
        } else if (entity instanceof ItemEntity) {
            ((ItemEntity)entity).setExtendedLifetime();
        }
        double speed = this.speed();
        int meta = ((Direction)state.getValue((Property)FACING)).get3DDataValue() - 2;
        int[] factorX = new int[]{0, 0, -1, 1};
        int[] factorZ = new int[]{-1, 1, 0, 0};
        if (entity.getY() > (double)pos.getY() + 0.5) {
            Vec3 vec3d = entity.getDeltaMovement();
            if (factorX[meta] == 0 && Math.abs((double)pos.getX() + 0.5 - entity.getX()) < 0.5 && Math.abs((double)pos.getX() + 0.5 - entity.getX()) > 0.1) {
                entity.setDeltaMovement(vec3d.x + Math.signum((double)pos.getX() + 0.5 - entity.getX()) * Math.min(speed, Math.abs((double)pos.getX() + 0.5 - entity.getX())) / 1.2, vec3d.y, vec3d.z);
            }
            if (factorZ[meta] == 0 && Math.abs((double)pos.getZ() + 0.5 - entity.getZ()) < 0.5 && Math.abs((double)pos.getZ() + 0.5 - entity.getZ()) > 0.1) {
                entity.setDeltaMovement(vec3d.x, vec3d.y, vec3d.z + Math.signum((double)pos.getZ() + 0.5 - entity.getZ()) * Math.min(speed, Math.abs((double)pos.getZ() + 0.5 - entity.getZ())) / 1.2);
            }
            entity.setDeltaMovement(vec3d.x + (double)factorX[meta] * speed, vec3d.y, vec3d.z + (double)factorZ[meta] * speed);
        }
    }

    protected double speed() {
        return 0.2;
    }
}

