/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.rightclick;

import com.google.common.collect.BiMap;
import dev.ftb.mods.ftbultimine.api.rightclick.RightClickHandler;
import dev.ftb.mods.ftbultimine.api.shape.ShapeContext;
import dev.ftb.mods.ftbultimine.client.PlatformUtil;
import dev.ftb.mods.ftbultimine.config.FTBUltimineServerConfig;
import dev.ftb.mods.ftbultimine.mixin.AxeItemAccess;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public enum AxeStripping implements RightClickHandler
{
    INSTANCE;


    @Override
    public int handleRightClickBlock(ShapeContext shapeContext, InteractionHand hand, Collection<BlockPos> positions) {
        ServerPlayer player = shapeContext.player();
        if (!((Boolean)FTBUltimineServerConfig.RIGHT_CLICK_AXE.get()).booleanValue() || !PlatformUtil.canAxeStrip(player.getMainHandItem())) {
            return 0;
        }
        HashSet<SoundEvent> sounds = new HashSet<SoundEvent>();
        Level level = player.level();
        ItemStack itemStack = player.getItemInHand(hand);
        AxeItemAccess axeItemAccess = (AxeItemAccess)Items.DIAMOND_AXE;
        for (BlockPos pos : positions) {
            BlockState state = player.level().getBlockState(pos);
            Optional<BlockState> stripping = axeItemAccess.invokeGetStripped(state);
            Optional scraping = WeatheringCopper.getPrevious((BlockState)state);
            Optional<BlockState> waxing = Optional.ofNullable((Block)((BiMap)HoneycombItem.WAX_OFF_BY_BLOCK.get()).get((Object)state.getBlock())).map(block -> block.withPropertiesOf(state));
            Optional<Object> actual = Optional.empty();
            if (stripping.isPresent()) {
                sounds.add(SoundEvents.AXE_STRIP);
                actual = stripping;
            } else if (scraping.isPresent()) {
                sounds.add(SoundEvents.AXE_SCRAPE);
                level.levelEvent((Player)player, 3005, pos, 0);
                actual = scraping;
            } else if (waxing.isPresent()) {
                sounds.add(SoundEvents.AXE_WAX_OFF);
                level.levelEvent((Player)player, 3004, pos, 0);
                actual = waxing;
            }
            if (!actual.isPresent()) continue;
            CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(player, pos, itemStack);
            level.setBlock(pos, (BlockState)actual.get(), 11);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)((BlockState)actual.get())));
            boolean result = this.hurtItemAndCheckIfBroken(player, hand);
            if (!result) continue;
            break;
        }
        sounds.forEach(sound -> level.playSound(null, shapeContext.origPos(), sound, SoundSource.BLOCKS, 1.0f, 1.0f));
        return sounds.size();
    }
}

