/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.util;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.Containers;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class GameUtil {
    public static final DecimalFormat NUMBER_F = new DecimalFormat("#,###.##");
    public static final StreamCodec<RegistryFriendlyByteBuf, BeehiveBlockEntity.BeeData> BEE_CODEC = StreamCodec.composite((StreamCodec)BeehiveBlockEntity.Occupant.STREAM_CODEC, BeehiveBlockEntity.BeeData::toOccupant, BeehiveBlockEntity.BeeData::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, List<BeehiveBlockEntity.BeeData>> BEES_CODEC = StreamCodec.of((buf, list) -> {
        buf.writeInt(list.size());
        list.forEach(bee -> BEE_CODEC.encode(buf, bee));
    }, buf -> {
        ArrayList<BeehiveBlockEntity.BeeData> list = new ArrayList<BeehiveBlockEntity.BeeData>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            list.add((BeehiveBlockEntity.BeeData)BEE_CODEC.decode(buf));
        }
        return list;
    });

    public static void spawnDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        if (!level.isClientSide()) {
            for (ItemStack i : drops) {
                if (i.isEmpty()) continue;
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)i);
            }
        }
    }

    public static BlockState getBlockFromItem(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem bi = (BlockItem)item;
            return bi.getBlock().defaultBlockState();
        }
        return Blocks.AIR.defaultBlockState();
    }

    public static FluidStack getFluidFromItem(ItemStack stack) {
        IFluidHandlerItem tank = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (tank != null) {
            for (int x = 0; x < tank.getTanks(); ++x) {
                if (tank.getFluidInTank(x).isEmpty()) continue;
                return tank.getFluidInTank(x);
            }
        }
        return FluidStack.EMPTY;
    }
}

