/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.dynamic;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicPack
implements PackResources {
    private static final Set<String> DOMAIN = Set.of("minecraft", "c", "modularbees");
    protected final PackType type;
    protected final Map<ResourceLocation, byte[]> data = this.createMap();
    private PackLocationInfo name;

    public DynamicPack(PackType type) {
        this.type = type;
    }

    public DynamicPack build(PackLocationInfo name) {
        this.name = name;
        return this;
    }

    protected abstract Map<ResourceLocation, byte[]> createMap();

    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... elements) {
        return null;
    }

    public void clear(PackType side) {
        if (this.type == side) {
            this.data.clear();
        }
    }

    public IoSupplier<InputStream> getResource(@NotNull PackType side, @NotNull ResourceLocation location) {
        byte[] byteArray;
        if (side == this.type && (byteArray = this.data.get(location)) != null) {
            return () -> new ByteArrayInputStream(byteArray);
        }
        return null;
    }

    public void listResources(@NotNull PackType side, @NotNull String namespace, @NotNull String path, @NotNull PackResources.ResourceOutput resourceOutput) {
        if (side == this.type) {
            if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            String finalPath = path;
            this.data.keySet().stream().filter(Objects::nonNull).filter(loc -> loc.getPath().startsWith(finalPath)).forEach(id -> {
                IoSupplier<InputStream> resource = this.getResource(side, (ResourceLocation)id);
                if (resource != null) {
                    resourceOutput.accept(id, resource);
                }
            });
        }
    }

    @NotNull
    public Set<String> getNamespaces(@NotNull PackType side) {
        return this.type == side ? DOMAIN : Set.of();
    }

    @NotNull
    public PackLocationInfo location() {
        return this.name;
    }

    public void close() {
    }
}

