/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.common.tileentities.hive;

import com.glodblock.github.glodium.util.GlodUtil;
import com.glodblock.github.modularbees.common.MBSingletons;
import com.glodblock.github.modularbees.common.caps.EnergyHandlerHost;
import com.glodblock.github.modularbees.common.caps.ItemHandlerHost;
import com.glodblock.github.modularbees.common.inventory.MBEnergyInventory;
import com.glodblock.github.modularbees.common.inventory.MBItemInventory;
import com.glodblock.github.modularbees.common.tileentities.hive.TileBeehivePart;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class TileBeehiveOverclocker
extends TileBeehivePart
implements ItemHandlerHost,
EnergyHandlerHost {
    public static final int POWER_USE = 100;
    protected final MBItemInventory electrode = new MBItemInventory(this, 1).setFilter(stack -> stack.getItem() instanceof HiveElectrode);
    protected final MBEnergyInventory energy = new MBEnergyInventory(this, 2000000).inputOnly();

    public TileBeehiveOverclocker(BlockPos pos, BlockState state) {
        super(GlodUtil.getTileType(TileBeehiveOverclocker.class, TileBeehiveOverclocker::new, (Block)MBSingletons.MODULAR_OVERCLOCKER), pos, state);
    }

    public float getBoostAndConsume(int bees) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            Item item2;
            ItemStack stack;
            ServerLevel server = (ServerLevel)level;
            if (this.isActive() && !(stack = this.electrode.getStackInSlot(0)).isEmpty() && (item2 = stack.getItem()) instanceof HiveElectrode) {
                int power;
                HiveElectrode e = (HiveElectrode)item2;
                if (this.energy.getEnergyStored() >= bees * 100 && (power = this.energy.forceExtractEnergy(bees * 100, false)) >= bees * 100) {
                    stack.hurtAndBreak(1, server, null, item -> this.electrode.setStackInSlot(0, ItemStack.EMPTY));
                    return e.getPower();
                }
            }
        }
        return 0.0f;
    }

    @Override
    public void saveTag(CompoundTag data, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveTag(data, provider);
        data.put("electrode", (Tag)this.electrode.serializeNBT(provider));
        data.put("energy", (Tag)this.energy.serializeNBT(provider));
    }

    @Override
    public void loadTag(CompoundTag data, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadTag(data, provider);
        this.electrode.deserializeNBT(provider, data.getCompound("electrode"));
        this.energy.deserializeNBT(provider, (Tag)data.getCompound("energy"));
    }

    @Override
    public IItemHandler getItemInventory() {
        return this.electrode;
    }

    public MBEnergyInventory getEnergyStorage() {
        return this.energy;
    }

    public MBEnergyInventory getEnergyStorage(Direction side) {
        if (side == null) {
            return this.getEnergyStorage();
        }
        if (side == this.getFacing()) {
            return this.energy;
        }
        return null;
    }

    @Override
    public MBItemInventory getHandlerByName(String name) {
        return this.electrode;
    }

    @Override
    public void addInventoryDrops(Level level, @NotNull BlockPos pos, List<ItemStack> drops) {
        drops.addAll(this.electrode.toList());
    }

    public Direction getFacing() {
        return MBSingletons.MODULAR_OVERCLOCKER.getFacing(this.getBlockState());
    }

    public static interface HiveElectrode {
        public float getPower();
    }
}

