/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.common.tileentities.hive;

import com.glodblock.github.glodium.util.GlodUtil;
import com.glodblock.github.modularbees.common.MBSingletons;
import com.glodblock.github.modularbees.common.caps.ItemHandlerHost;
import com.glodblock.github.modularbees.common.inventory.MBItemInventory;
import com.glodblock.github.modularbees.common.inventory.SlotListener;
import com.glodblock.github.modularbees.common.tileentities.base.TileMBModularCore;
import com.glodblock.github.modularbees.common.tileentities.hive.TileBeehivePart;
import com.glodblock.github.modularbees.common.tileentities.hive.TileModularBeehive;
import com.glodblock.github.modularbees.util.GameUtil;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class TileBeehiveFeeder
extends TileBeehivePart
implements ItemHandlerHost,
SlotListener {
    protected final MBItemInventory feeder = new MBItemInventory(this, 9);

    public TileBeehiveFeeder(BlockPos pos, BlockState state) {
        super(GlodUtil.getTileType(TileBeehiveFeeder.class, TileBeehiveFeeder::new, (Block)MBSingletons.MODULAR_FEEDER), pos, state);
    }

    public FeedSlot checkFlower(Bee bee) {
        IntListIterator intListIterator = this.getRandomSlots().iterator();
        while (intListIterator.hasNext()) {
            ProductiveBee productiveBee;
            ProductiveBee productiveBee2;
            int x = (Integer)intListIterator.next();
            ItemStack item = this.feeder.getStackInSlot(x);
            if (item.isEmpty()) continue;
            BlockState block = GameUtil.getBlockFromItem(item);
            if (bee instanceof ProductiveBee ? (productiveBee2 = (ProductiveBee)bee).isFlowerBlock(block) || productiveBee2.isFlowerItem(item) : block.is(BlockTags.FLOWERS)) {
                return new FeedSlot(FeedResult.NON_CONSUME, (IItemHandler)this.feeder, x);
            }
            FluidStack fluid = GameUtil.getFluidFromItem(item);
            if (fluid.isEmpty()) continue;
            BlockState fluidBlock = fluid.getFluid().defaultFluidState().createLegacyBlock();
            if (!(bee instanceof ProductiveBee) || !(productiveBee = (ProductiveBee)bee).isFlowerBlock(fluidBlock)) continue;
            return new FeedSlot(FeedResult.NON_CONSUME, (IItemHandler)this.feeder, x);
        }
        return FeedSlot.FAIL;
    }

    private IntList getRandomSlots() {
        IntArrayList slots = new IntArrayList((Iterator)IntStream.range(0, this.feeder.getSlots()).iterator());
        Collections.shuffle(slots);
        return slots;
    }

    @Override
    public void saveTag(CompoundTag data, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveTag(data, provider);
        data.put("feeder", (Tag)this.feeder.serializeNBT(provider));
    }

    @Override
    public void loadTag(CompoundTag data, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadTag(data, provider);
        this.feeder.deserializeNBT(provider, data.getCompound("feeder"));
    }

    @Override
    public MBItemInventory getHandlerByName(String name) {
        return this.feeder;
    }

    @Override
    public void addInventoryDrops(Level level, @NotNull BlockPos pos, List<ItemStack> drops) {
        drops.addAll(this.feeder.toList());
    }

    @Override
    public IItemHandler getItemInventory() {
        return this.feeder;
    }

    @Override
    public void onChange(IItemHandler inv, int slot) {
        TileMBModularCore tileMBModularCore;
        if (inv == this.feeder && this.isActive() && (tileMBModularCore = this.core) instanceof TileModularBeehive) {
            TileModularBeehive hive = (TileModularBeehive)tileMBModularCore;
            hive.onFeederChange(inv, slot);
        }
    }

    public record FeedSlot(FeedResult result, IItemHandler inv, int slot) {
        public static FeedSlot FAIL = new FeedSlot(FeedResult.FAIL, null, -1);

        public boolean isSuccess() {
            return this.result != FeedResult.FAIL;
        }
    }

    public static enum FeedResult {
        FAIL,
        NON_CONSUME,
        TRANSFORM;

    }
}

