/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.common.tileentities.hive;

import com.glodblock.github.glodium.util.GlodUtil;
import com.glodblock.github.modularbees.common.MBSingletons;
import com.glodblock.github.modularbees.common.caps.FluidHandlerHost;
import com.glodblock.github.modularbees.common.caps.ItemHandlerHost;
import com.glodblock.github.modularbees.common.fluids.FluidDragonBreath;
import com.glodblock.github.modularbees.common.inventory.IO;
import com.glodblock.github.modularbees.common.inventory.MBFluidInventory;
import com.glodblock.github.modularbees.common.inventory.MBItemInventory;
import com.glodblock.github.modularbees.common.tileentities.hive.TileBeehivePart;
import com.glodblock.github.modularbees.util.ServerTickTile;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class TileBeehiveDragon
extends TileBeehivePart
implements ItemHandlerHost,
FluidHandlerHost,
ServerTickTile {
    private final MBFluidInventory tank = new MBFluidInventory(this, 16000).outputOnly();
    private final MBItemInventory bottle = new MBItemInventory(this, 2, MBItemInventory.ItemFilter.of(Items.GLASS_BOTTLE)).setIO(1, IO.OUT);

    public TileBeehiveDragon(BlockPos pos, BlockState state) {
        super(GlodUtil.getTileType(TileBeehiveDragon.class, TileBeehiveDragon::new, (Block)MBSingletons.MODULAR_DRAGON_HIVE), pos, state);
    }

    public void addDragonBreath(int bees, Level world) {
        int amount = world.random.nextInt(bees / 2, bees + 1) * 400;
        if (amount > 0) {
            this.tank.forceFill(new FluidStack((Fluid)FluidDragonBreath.getFluid(), amount), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    public void saveTag(CompoundTag data, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveTag(data, provider);
        CompoundTag tank = new CompoundTag();
        this.tank.writeToNBT(provider, tank);
        data.put("tank", (Tag)tank);
    }

    @Override
    public void loadTag(CompoundTag data, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadTag(data, provider);
        this.tank.readFromNBT(provider, data.getCompound("tank"));
    }

    public MBFluidInventory getFluidInventory() {
        return this.tank;
    }

    @Override
    public IItemHandler getItemInventory() {
        return this.bottle;
    }

    @Override
    public MBItemInventory getHandlerByName(String name) {
        return this.bottle;
    }

    @Override
    public void tickServer(Level world, BlockState state) {
        this.fillBottle();
    }

    private void fillBottle() {
        ItemStack left;
        if (this.tank.getFluidAmount() >= 250 && this.bottle.getStackInSlot(0).getItem() == Items.GLASS_BOTTLE && (left = this.bottle.forceInsertItem(1, new ItemStack((ItemLike)Items.DRAGON_BREATH), false)).isEmpty()) {
            this.tank.drain(250, IFluidHandler.FluidAction.EXECUTE);
            this.bottle.extractItem(0, 1, false);
        }
    }
}

