/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.common.tileentities.hive;

import com.glodblock.github.glodium.util.GlodUtil;
import com.glodblock.github.modularbees.ModularBees;
import com.glodblock.github.modularbees.common.MBSingletons;
import com.glodblock.github.modularbees.common.caps.ItemHandlerHost;
import com.glodblock.github.modularbees.common.inventory.MBItemInventory;
import com.glodblock.github.modularbees.common.tileentities.base.TileMBModularCore;
import com.glodblock.github.modularbees.common.tileentities.hive.TileBeehivePart;
import com.glodblock.github.modularbees.common.tileentities.hive.TileModularBeehive;
import com.glodblock.github.modularbees.util.ServerTickTile;
import com.mojang.serialization.DynamicOps;
import cy.jdkdigital.productivebees.common.entity.bee.SolitaryBee;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.init.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileBeehiveAlveary
extends TileBeehivePart
implements ServerTickTile,
ItemHandlerHost {
    public static int MAX_BEES = 5;
    protected final List<BeehiveBlockEntity.BeeData> bees = new ArrayList<BeehiveBlockEntity.BeeData>();
    protected final MBItemInventory cageIn = new MBItemInventory(this, 1, BeeCage::isFilled).setSlotLimit(1);
    protected final MBItemInventory cageOut = new MBItemInventory(this, 1, this::isEmptyCage).setSlotLimit(1);
    private final IItemHandler exposed = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.cageIn, this.cageOut});

    public TileBeehiveAlveary(BlockPos pos, BlockState state) {
        super(GlodUtil.getTileType(TileBeehiveAlveary.class, TileBeehiveAlveary::new, (Block)MBSingletons.MODULAR_ALVEARY), pos, state);
    }

    public boolean isEmptyCage(ItemStack stack) {
        return stack.getItem() instanceof BeeCage && !BeeCage.isFilled((ItemStack)stack);
    }

    public void collectBees(Consumer<BeehiveBlockEntity.BeeData> collector) {
        this.bees.forEach(collector);
    }

    public List<BeehiveBlockEntity.BeeData> getBees() {
        return this.bees;
    }

    @Nullable
    public BeehiveBlockEntity.BeeData getBee(int x) {
        if (x >= this.bees.size()) {
            return null;
        }
        return this.bees.get(x);
    }

    public void setBees(List<BeehiveBlockEntity.BeeData> bees) {
        this.bees.clear();
        this.bees.addAll(bees);
        this.setChanged();
    }

    public void loadBees(List<BeehiveBlockEntity.Occupant> occupants) {
        this.bees.clear();
        occupants.stream().map(BeehiveBlockEntity.BeeData::new).forEach(this.bees::add);
        this.notifyCore();
    }

    public boolean hasRoom() {
        return this.bees.size() < MAX_BEES;
    }

    public void addBee(Level world, Bee bee) {
        bee.stopRiding();
        bee.ejectPassengers();
        world.playSound(null, this.getBlockPos(), SoundEvents.BEEHIVE_ENTER, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.bees.add(new BeehiveBlockEntity.BeeData(BeehiveBlockEntity.Occupant.of((Entity)bee)));
        bee.discard();
        this.setChanged();
    }

    @Override
    public void saveTag(CompoundTag data, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveTag(data, provider);
        data.put("bees", (Tag)BeehiveBlockEntity.Occupant.LIST_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.bees.stream().map(BeehiveBlockEntity.BeeData::toOccupant).toList()).getOrThrow());
        data.put("cageIn", (Tag)this.cageIn.serializeNBT(provider));
        data.put("cageOut", (Tag)this.cageOut.serializeNBT(provider));
    }

    @Override
    public void loadTag(CompoundTag data, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadTag(data, provider);
        BeehiveBlockEntity.Occupant.LIST_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)data.get("bees")).resultOrPartial(bee -> ModularBees.LOGGER.error("Failed to parse bees: '{}'", bee)).ifPresent(this::loadBees);
        this.cageIn.deserializeNBT(provider, data.getCompound("cageIn"));
        this.cageOut.deserializeNBT(provider, data.getCompound("cageOut"));
    }

    @Override
    public MBItemInventory getHandlerByName(String name) {
        return switch (name) {
            case "in" -> this.cageIn;
            case "out" -> this.cageOut;
            default -> null;
        };
    }

    public ItemStack emptyCage(ItemStack cage) {
        if (cage.getItem() == ModItems.STURDY_BEE_CAGE.get()) {
            return new ItemStack((Holder)ModItems.STURDY_BEE_CAGE);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void tickServer(Level world, BlockState state) {
        Entity entity;
        ItemStack out;
        Bee bee;
        ItemStack in = this.cageIn.getStackInSlot(0);
        if (BeeCage.isFilled((ItemStack)in) && this.hasRoom() && (bee = BeeCage.getEntityFromStack((ItemStack)in, (Level)world, (boolean)true)) != null && !(bee instanceof SolitaryBee) && bee.getAge() >= 0) {
            this.addBee(world, bee);
            this.cageIn.setStackInSlot(0, this.emptyCage(in));
            this.notifyCore();
        }
        if (this.isEmptyCage(out = this.cageOut.getStackInSlot(0)) && !this.bees.isEmpty() && (entity = this.bees.getLast().toOccupant().createEntity(world, this.getBlockPos())) instanceof Bee) {
            Bee bee2 = (Bee)entity;
            bee2.setHivePos(this.getBlockPos());
            BeeCage.captureEntity((Bee)bee2, (ItemStack)out);
            this.bees.removeLast();
            this.cageOut.setStackInSlot(0, out);
            this.setChanged();
            this.notifyCore();
        }
    }

    public void notifyCore() {
        TileMBModularCore tileMBModularCore;
        if (this.isActive() && (tileMBModularCore = this.core) instanceof TileModularBeehive) {
            TileModularBeehive hive = (TileModularBeehive)tileMBModularCore;
            hive.onBeeChange();
        }
    }

    @Override
    public IItemHandler getItemInventory() {
        return this.exposed;
    }

    @Override
    public void addInventoryDrops(Level world, @NotNull BlockPos pos, List<ItemStack> drops) {
        drops.addAll(this.cageIn.toList());
        drops.addAll(this.cageOut.toList());
        BlockPos releasePos = this.getBlockPos();
        for (Direction dir : Direction.values()) {
            BlockPos checkPos = pos.relative(dir);
            if (!world.getBlockState(checkPos).getCollisionShape((BlockGetter)world, checkPos).isEmpty()) continue;
            releasePos = checkPos;
            break;
        }
        for (BeehiveBlockEntity.BeeData data : this.bees) {
            Entity entity = data.toOccupant().createEntity(world, releasePos);
            if (entity == null) continue;
            entity.setPos(releasePos.getCenter());
            world.addFreshEntity(entity);
        }
    }
}

