/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.common.tileentities.base;

import com.glodblock.github.modularbees.ModularBees;
import com.glodblock.github.modularbees.common.blocks.base.BlockMBTileBase;
import com.glodblock.github.modularbees.common.inventory.MBItemInventory;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileMBBase
extends BlockEntity {
    public TileMBBase(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addInventoryDrops(Level level, @NotNull BlockPos pos, List<ItemStack> drops) {
    }

    public boolean notLoaded() {
        return !this.level.hasChunkAt(this.worldPosition);
    }

    public final GlobalPos getGlobalPos() {
        if (this.level == null) {
            throw new IllegalStateException("Block entity is not in a level");
        }
        return GlobalPos.of((ResourceKey)this.level.dimension(), (BlockPos)this.getBlockPos());
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public final void loadAdditional(CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        if (tag.contains("#upd", 7) && tag.size() == 1) {
            byte[] updateData = tag.getByteArray("#upd");
            if (this.readUpdateData(new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])updateData))) && this.level != null) {
                this.requestModelDataUpdate();
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 0);
            }
        } else {
            super.loadAdditional(tag, provider);
            this.loadTag(tag, provider);
        }
    }

    public final void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.saveTag(tag, provider);
    }

    public void saveTag(CompoundTag data, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
    }

    public void loadTag(CompoundTag data, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
    }

    protected boolean readFromStream(FriendlyByteBuf data) {
        return false;
    }

    protected void writeToStream(FriendlyByteBuf data) {
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag data = new CompoundTag();
        FriendlyByteBuf stream = new FriendlyByteBuf(Unpooled.buffer());
        this.writeToStream(stream);
        stream.capacity(stream.readableBytes());
        data.putByteArray("#upd", stream.array());
        return data;
    }

    private boolean readUpdateData(FriendlyByteBuf stream) {
        boolean output = false;
        try {
            output = this.readFromStream(stream);
        }
        catch (Throwable err) {
            ModularBees.LOGGER.warn("Fail to read client update data.", err);
        }
        return output;
    }

    @Nullable
    public MBItemInventory getHandlerByName(String name) {
        return null;
    }

    public void markForUpdate() {
        this.requestModelDataUpdate();
        if (this.level != null && !this.isRemoved() && !this.notLoaded()) {
            BlockMBTileBase block;
            BlockState newState;
            boolean alreadyUpdated = false;
            BlockState currentState = this.getBlockState();
            Block block2 = currentState.getBlock();
            if (block2 instanceof BlockMBTileBase && currentState != (newState = (block = (BlockMBTileBase)block2).getTileEntityBlockState(currentState, this))) {
                this.level.setBlockAndUpdate(this.worldPosition, newState);
                alreadyUpdated = true;
            }
            if (!alreadyUpdated) {
                this.level.sendBlockUpdated(this.worldPosition, currentState, currentState, 1);
            }
        }
    }

    public void fastUpdate() {
        if (this.level != null && !this.isRemoved() && !this.notLoaded()) {
            BlockState currentState = this.getBlockState();
            this.level.sendBlockUpdated(this.worldPosition, currentState, currentState, 1);
        }
    }
}

