/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.common.blocks.hive;

import com.glodblock.github.modularbees.client.util.ConnectBlock;
import com.glodblock.github.modularbees.common.blocks.base.BlockMBGuiBase;
import com.glodblock.github.modularbees.common.blocks.hive.Hive;
import com.glodblock.github.modularbees.common.inventory.MBFluidInventory;
import com.glodblock.github.modularbees.common.tileentities.hive.TileModularBeehive;
import com.glodblock.github.modularbees.container.ContainerMBModularBeehive;
import com.glodblock.github.modularbees.container.MBGuiHandler;
import com.glodblock.github.modularbees.dynamic.DyResourcePack;
import com.glodblock.github.modularbees.util.ContainerResolver;
import com.glodblock.github.modularbees.util.GameUtil;
import com.glodblock.github.modularbees.util.RotorBlocks;
import cy.jdkdigital.productivebees.init.ModItems;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class BlockModularBeehive
extends BlockMBGuiBase<TileModularBeehive>
implements ConnectBlock,
Hive {
    public BlockModularBeehive() {
        super(BlockModularBeehive.hive());
    }

    @Override
    public TagKey<Block> harvestTool() {
        return BlockTags.MINEABLE_WITH_AXE;
    }

    @Override
    public ItemInteractionResult check(TileModularBeehive tile, ItemStack stack, Level world, BlockPos pos, BlockHitResult hit, Player p) {
        if (!world.isClientSide()) {
            MBFluidInventory tank = tile.getFluidInventory();
            if (stack.is(Items.GLASS_BOTTLE) && tank.getFluidAmount() >= 250) {
                stack.shrink(1);
                tank.drain(250, IFluidHandler.FluidAction.EXECUTE);
                if (!p.addItem(new ItemStack((ItemLike)Items.HONEY_BOTTLE))) {
                    GameUtil.spawnDrops(world, p.getOnPos(), List.of(new ItemStack((ItemLike)Items.HONEY_BOTTLE)));
                }
                return ItemInteractionResult.SUCCESS;
            }
            if (stack.is(Items.BUCKET) && tank.getFluidAmount() >= 1000) {
                stack.shrink(1);
                tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                if (!p.addItem(new ItemStack((Holder)ModItems.HONEY_BUCKET))) {
                    GameUtil.spawnDrops(world, p.getOnPos(), List.of(new ItemStack((Holder)ModItems.HONEY_BUCKET)));
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return null;
    }

    @Override
    public void openGui(TileModularBeehive tile, Player p) {
        tile.formStructure();
        if (tile.isFormed()) {
            MBGuiHandler.open(ContainerMBModularBeehive.TYPE.type(), p, ContainerResolver.of(tile));
        } else {
            p.displayClientMessage((Component)Component.translatable((String)"modularbees.chat.beehive_unformed"), true);
        }
    }

    @Override
    public boolean canConnect(BlockGetter world, BlockPos otherPos) {
        return world.getBlockState(otherPos).getBlock() instanceof Hive;
    }

    @Override
    public RotorBlocks getRotorStrategy() {
        return RotorBlocks.HORIZONTAL;
    }

    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        BlockState state = super.defaultBlockState();
        return (BlockState)state.setValue((Property)this.getRotorStrategy().property(), (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @Override
    protected void loadBlockModel(DyResourcePack pack) {
    }
}

