/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees;

import com.glodblock.github.modularbees.client.MBClientRegistryHandler;
import com.glodblock.github.modularbees.common.MBRegistryHandler;
import com.glodblock.github.modularbees.common.MBSingletons;
import com.glodblock.github.modularbees.common.fluids.FluidDragonBreath;
import com.glodblock.github.modularbees.common.hooks.TooltipHook;
import com.glodblock.github.modularbees.dynamic.DyDataPack;
import com.glodblock.github.modularbees.dynamic.DyResourcePack;
import com.glodblock.github.modularbees.dynamic.MBPackSource;
import com.glodblock.github.modularbees.network.MBNetworkHandler;
import com.glodblock.github.modularbees.util.DataProvider;
import com.mojang.logging.LogUtils;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import org.slf4j.Logger;

@Mod(value="modularbees")
public class ModularBees {
    public static final String MODID = "modularbees";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static ModularBees INSTANCE;
    public static final DyDataPack DATA_PACK;
    public static final DyResourcePack RESOURCE_PACK;

    public ModularBees(IEventBus bus, ModContainer container) {
        assert (INSTANCE == null);
        INSTANCE = this;
        if (!container.getModId().equals(MODID)) {
            throw new IllegalArgumentException("Invalid ID: modularbees");
        }
        bus.addListener(e -> {
            if (e.getRegistryKey().equals(Registries.CREATIVE_MODE_TAB)) {
                MBRegistryHandler.INSTANCE.registerTab((Registry<CreativeModeTab>)e.getRegistry(Registries.CREATIVE_MODE_TAB));
                return;
            }
            if (e.getRegistryKey().equals(Registries.BLOCK)) {
                MBSingletons.init(MBRegistryHandler.INSTANCE);
                MBRegistryHandler.INSTANCE.runRegister();
            }
        });
        if (FMLEnvironment.dist.isClient()) {
            bus.register((Object)MBClientRegistryHandler.INSTANCE);
        }
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::addPackFinders);
        bus.addListener(arg_0 -> ((MBNetworkHandler)MBNetworkHandler.INSTANCE).onRegister(arg_0));
        bus.register((Object)MBRegistryHandler.INSTANCE);
        NeoForge.EVENT_BUS.register((Object)TooltipHook.INSTANCE);
    }

    public void addPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            RESOURCE_PACK.clear(event.getPackType());
            event.addRepositorySource((RepositorySource)new MBPackSource("modularbees:dynamic_assets", event.getPackType(), RESOURCE_PACK::build));
        } else if (event.getPackType() == PackType.SERVER_DATA) {
            DATA_PACK.clear(event.getPackType());
            this.collectData();
            event.addRepositorySource((RepositorySource)new MBPackSource("modularbees:dynamic_data", event.getPackType(), DATA_PACK::build));
        }
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        MBRegistryHandler.INSTANCE.init();
    }

    public void clientSetup(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Fluid)FluidDragonBreath.getFluid(), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Fluid)FluidDragonBreath.getFlowFluid(), (RenderType)RenderType.translucent());
    }

    public static ResourceLocation id(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)id);
    }

    private void collectData() {
        for (ItemLike item : MBRegistryHandler.INSTANCE.getItems()) {
            if (!(item instanceof DataProvider)) continue;
            DataProvider provider = (DataProvider)item;
            provider.load(DATA_PACK);
        }
    }

    static {
        DATA_PACK = new DyDataPack();
        RESOURCE_PACK = new DyResourcePack();
    }
}

