/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.crystalix.network;

import com.satherov.crystalix.Crystalix;
import com.satherov.crystalix.content.CrystalixUtil;
import com.satherov.crystalix.content.item.CrystalixWand;
import com.satherov.crystalix.content.properties.BlockProperties;
import com.satherov.crystalix.content.properties.IProperty;
import com.satherov.crystalix.content.properties.ITranslatableProperty;
import com.satherov.crystalix.core.lang.CrystalixLanguage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CyclePropertyPayload(String key, String value) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, CyclePropertyPayload> STREAM_CODEC = CustomPacketPayload.codec(CyclePropertyPayload::encode, CyclePropertyPayload::new);
    public static final CustomPacketPayload.Type<CyclePropertyPayload> TYPE = new CustomPacketPayload.Type(Crystalix.rl("cycle_property"));

    private CyclePropertyPayload(FriendlyByteBuf buffer) {
        this(buffer.readUtf(100), buffer.readUtf(100));
    }

    public CyclePropertyPayload(IProperty<?> property) {
        this(property.getKey(), property.getValueString());
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeUtf(this.key);
        buffer.writeUtf(this.value);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static class Handler {
        public static void handle(CyclePropertyPayload message, IPayloadContext ctx) {
            ctx.enqueueWork(() -> {
                Player patt0$temp;
                if (ctx.flow().isServerbound() && (patt0$temp = ctx.player()) instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    ItemStack wand = CrystalixUtil.getWand((Player)player);
                    if (wand.isEmpty()) {
                        return;
                    }
                    BlockProperties properties = new BlockProperties(wand);
                    ITranslatableProperty<?> property = properties.get(message.key);
                    if (property == null) {
                        return;
                    }
                    property.setValueString(message.value);
                    CrystalixWand.sendMessage((Player)player, property);
                    player.getInventory().setChanged();
                }
            }).exceptionally(e -> {
                ctx.disconnect((Component)CrystalixLanguage.NETWORK_CYCLE_FAILED.translate(e.getMessage()));
                return null;
            });
        }
    }
}

