/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.crystalix.content.item;

import com.satherov.crystalix.content.BatchProcessor;
import com.satherov.crystalix.content.CrystalixRegistry;
import com.satherov.crystalix.content.block.CrystalixGlass;
import com.satherov.crystalix.content.properties.BlockProperties;
import com.satherov.crystalix.content.properties.ITranslatableProperty;
import com.satherov.crystalix.core.annotations.NothingNull;
import com.satherov.crystalix.core.lang.CrystalixLanguage;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

@NothingNull
public class CrystalixWand
extends Item {
    public CrystalixWand(Item.Properties properties) {
        super(properties.stacksTo(1).component(CrystalixRegistry.INVISIBLE, (Object)false).component(CrystalixRegistry.SHADELESS, (Object)false).component(CrystalixRegistry.REINFORCED, (Object)false).component(CrystalixRegistry.WATERLOGGABLE, (Object)false).component(CrystalixRegistry.LIGHT, (Object)BlockProperties.Light.NONE).component(CrystalixRegistry.GHOST, (Object)BlockProperties.Ghost.BLOCK_ALL));
    }

    public static void sendMessage(Player player, ITranslatableProperty<?> property) {
        player.displayClientMessage((Component)property.getTranslation(), true);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)CrystalixLanguage.TOOLTIP_BULK.translateFormatted(ChatFormatting.GRAY));
        Arrays.stream(new BlockProperties((ItemStack)stack).properties).toList().forEach(property -> tooltipComponents.add((Component)property.getTranslation()));
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.FAIL;
        }
        ServerLevel level2 = (ServerLevel)level;
        Player player = context.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.FAIL;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        BlockPos blockpos = context.getClickedPos();
        if (!this.applyToBlock(level2, blockpos, player2)) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }

    public boolean applyToBlock(ServerLevel level, BlockPos pos, ServerPlayer player) {
        Block block = level.getBlockState(pos).getBlock();
        if (!(block instanceof CrystalixGlass)) {
            return false;
        }
        CrystalixGlass glass = (CrystalixGlass)block;
        ItemStack wand = player.getMainHandItem();
        if (player.isShiftKeyDown()) {
            BatchProcessor.schedule(BatchProcessor.Batch.of(player, pos, wand));
        } else {
            level.setBlock(pos, glass.modifyFromWand(level.getBlockState(pos), wand), 3);
        }
        return true;
    }
}

