/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.industrialization_overdrive.machines.components.craft;

import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.DropableComponent;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import dev.wp.industrialization_overdrive.IO;
import dev.wp.industrialization_overdrive.machines.guicomponents.multiprocessingarraymachineslot.MultiProcessingArrayMachineSlot;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.swedz.tesseract.neoforge.compat.mi.api.ComponentStackHolder;

public final class MultiProcessingArrayMachineComponent
implements IComponent.ServerOnly,
DropableComponent,
ComponentStackHolder {
    public static final ResourceLocation ID = IO.id("multi_processing_array_machine");
    private ItemStack machines = ItemStack.EMPTY;
    private MachineRecipeType machineRecipeType;

    public ItemStack getMachines() {
        return this.machines;
    }

    public boolean hasMachines() {
        return !this.machines.isEmpty() && this.machineRecipeType != null;
    }

    public int getMachineCount() {
        return this.machines.getCount();
    }

    public MachineRecipeType getMachineRecipeType() {
        return this.machineRecipeType;
    }

    public void setMachines(MachineBlockEntity be, ItemStack machines) {
        this.setStack(machines);
        be.setChanged();
        be.sync();
    }

    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("machinesStack", this.machines.saveOptional(registries));
    }

    public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
        this.machines = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("machinesStack"));
        if (!this.machines.isEmpty()) {
            this.machineRecipeType = MultiProcessingArrayMachineSlot.getMachine(this.machines).recipeType();
        }
    }

    public ItemStack getDrop() {
        return this.machines;
    }

    public ItemStack getStack() {
        return this.machines;
    }

    public void setStack(ItemStack stack) {
        this.machines = stack;
        this.machineRecipeType = this.machines.isEmpty() ? null : MultiProcessingArrayMachineSlot.getMachine(this.machines).recipeType();
    }
}

