/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.entry.linkhandler;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookLink;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.entry.BookEntryScreen;
import com.klikli_dev.modonomicon.client.gui.book.entry.linkhandler.LinkHandler;
import com.klikli_dev.modonomicon.data.BookDataManager;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;

public class BookLinkHandler
extends LinkHandler {
    public BookLinkHandler(BookEntryScreen screen) {
        super(screen);
    }

    @Override
    public LinkHandler.ClickResult handleClick(@NotNull Style pStyle) {
        ClickEvent event = pStyle.getClickEvent();
        if (event == null) {
            return LinkHandler.ClickResult.UNHANDLED;
        }
        if (event.getAction() != ClickEvent.Action.CHANGE_PAGE) {
            return LinkHandler.ClickResult.UNHANDLED;
        }
        if (!BookLink.isBookLink(event.getValue())) {
            return LinkHandler.ClickResult.UNHANDLED;
        }
        BookLink link = BookLink.from(this.book(), event.getValue());
        Book book = BookDataManager.get().getBook(link.bookId);
        if (link.entryId != null) {
            BookEntry entry = book.getEntry(link.entryId);
            if (!BookUnlockStateManager.get().isUnlockedFor(this.player(), entry)) {
                return LinkHandler.ClickResult.FAILURE;
            }
            Integer page = link.pageNumber;
            if (link.pageAnchor != null) {
                page = entry.getPageNumberForAnchor(link.pageAnchor);
            }
            if (page != null && !BookUnlockStateManager.get().isUnlockedFor(this.player(), entry.getPages().get(page))) {
                return LinkHandler.ClickResult.UNHANDLED;
            }
            if (page == null) {
                page = 0;
            }
            int currentPageNumber = this.screen().getCurrentPageNumber();
            BookGuiManager.get().pushHistory(this.book().getId(), this.category().getId(), this.entry().getId(), currentPageNumber);
            BookGuiManager.get().openEntry(link.bookId, link.entryId, page);
        } else if (link.categoryId != null) {
            BookGuiManager.get().openEntry(link.bookId, link.categoryId, null, 0);
        } else {
            BookGuiManager.get().openEntry(link.bookId, null, null, 0);
        }
        return LinkHandler.ClickResult.SUCCESS;
    }
}

