/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.basic;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.resources.ResourceLocation;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiFluxCore;
import sonar.fluxnetworks.client.gui.basic.GuiFocusable;
import sonar.fluxnetworks.client.mui.MUIIntegration;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.common.util.FluxUtils;

public abstract class GuiPopupCore<T extends GuiFluxCore>
extends GuiFocusable {
    protected final List<GuiButtonCore> mButtons = new ArrayList<GuiButtonCore>();
    public final T mHost;
    protected float mAlpha = 0.0f;

    public GuiPopupCore(@Nonnull T host) {
        super((FluxMenu)host.getMenu(), ((GuiFluxCore)((Object)host)).mPlayer);
        this.mHost = host;
    }

    public void init() {
        super.init();
        this.mButtons.clear();
    }

    public void onClose() {
        this.mButtons.clear();
    }

    public final void render(@Nonnull GuiGraphics gr, int mouseX, int mouseY, float deltaTicks) {
        throw new UnsupportedOperationException();
    }

    protected void renderLabels(@Nonnull GuiGraphics gr, int mouseX, int mouseY) {
        throw new UnsupportedOperationException();
    }

    protected final void renderBg(@Nonnull GuiGraphics gr, float deltaTicks, int mouseX, int mouseY) {
        throw new UnsupportedOperationException();
    }

    public void drawForegroundLayer(@Nonnull GuiGraphics gr, int mouseX, int mouseY, float deltaTicks) {
        for (GuiButtonCore button : this.mButtons) {
            button.drawButton(gr, mouseX, mouseY, deltaTicks);
        }
    }

    public void drawBackgroundLayer(@Nonnull GuiGraphics gr, int mouseX, int mouseY, float deltaTicks) {
        this.mAlpha = Math.min(1.0f, this.mAlpha + deltaTicks / 6.0f);
        if (GuiPopupCore.useModernDesign()) {
            MUIIntegration.drawBackgroundAndFrame(gr, this.width, this.height, ((GuiFluxCore)((Object)this.mHost)).getNetwork().getNetworkColor(), this.mAlpha);
        } else {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.mAlpha);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
            this.blitBackgroundOrFrame(gr);
            int color = ((GuiFluxCore)((Object)this.mHost)).getNetwork().getNetworkColor();
            RenderSystem.setShaderColor((float)FluxUtils.getRed(color), (float)FluxUtils.getGreen(color), (float)FluxUtils.getBlue(color), (float)this.mAlpha);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)FRAME);
            this.blitBackgroundOrFrame(gr);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int bgColor = (int)(this.mAlpha * 128.0f) << 24;
        gr.fill(0, 0, this.width, this.height, bgColor);
        for (Renderable widget : this.renderables) {
            widget.render(gr, mouseX, mouseY, deltaTicks);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean result = false;
        for (GuiButtonCore button : this.mButtons) {
            if (!button.mClickable || !button.isMouseHovered(mouseX, mouseY)) continue;
            this.onButtonClicked(button, (int)mouseX, (int)mouseY, mouseButton);
            result = true;
            break;
        }
        for (GuiEventListener child : this.children()) {
            if (!child.mouseClicked(mouseX, mouseY, mouseButton)) continue;
            this.setFocused(child);
            if (mouseButton == 0) {
                this.setDragging(true);
            }
            return true;
        }
        boolean focused = false;
        for (GuiEventListener child : this.children()) {
            EditBox editBox;
            if (!(child instanceof EditBox) || !(editBox = (EditBox)child).isFocused() || !editBox.isMouseOver(mouseX, mouseY)) continue;
            focused = true;
            break;
        }
        if (!focused) {
            this.setFocused(null);
            return true;
        }
        return result;
    }

    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
    }
}

