/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.api.device;

import javax.annotation.Nonnull;

public enum FluxDeviceType {
    POINT(0x882828),
    PLUG(6330162),
    STORAGE(2711178),
    CONTROLLER(6584440);

    public static final FluxDeviceType[] VALUES;
    public final int mColor;

    private FluxDeviceType(int color) {
        this.mColor = color;
    }

    @Nonnull
    public static FluxDeviceType fromId(byte id) {
        return VALUES[id];
    }

    public byte getId() {
        return (byte)this.ordinal();
    }

    public boolean isPlug() {
        return this == PLUG;
    }

    public boolean isPoint() {
        return this == POINT;
    }

    public boolean isController() {
        return this == CONTROLLER;
    }

    public boolean isStorage() {
        return this == STORAGE;
    }

    static {
        VALUES = FluxDeviceType.values();
    }
}

