/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.network.messages;

import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.SulfuricFluxEmitterBlock;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.SulfuricFluxEmitterBlockEntity;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.SulfuricFluxEmitterSelectedPoint;
import com.klikli_dev.theurgy.network.Message;
import com.klikli_dev.theurgy.registry.BlockRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class MessageShowSulfuricFluxEmitterStatus
implements Message {
    public static final CustomPacketPayload.Type<MessageShowSulfuricFluxEmitterStatus> TYPE = new CustomPacketPayload.Type(Theurgy.loc("show_sulfuric_flux_emitter_status"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageShowSulfuricFluxEmitterStatus> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, m -> m.blockPos, (StreamCodec)SulfuricFluxEmitterSelectedPoint.STREAM_CODEC.apply(ByteBufCodecs.list()), m -> m.sourcePedestals, (StreamCodec)ByteBufCodecs.optional(SulfuricFluxEmitterSelectedPoint.STREAM_CODEC), m -> Optional.ofNullable(m.targetPedestal), (StreamCodec)ByteBufCodecs.optional(SulfuricFluxEmitterSelectedPoint.STREAM_CODEC), m -> Optional.ofNullable(m.resultPedestal), (blockPos, sourcePedestals, targetPedestal, resultPedestal) -> new MessageShowSulfuricFluxEmitterStatus((BlockPos)blockPos, (List<SulfuricFluxEmitterSelectedPoint>)sourcePedestals, targetPedestal.orElse(null), resultPedestal.orElse(null)));
    private final List<SulfuricFluxEmitterSelectedPoint> sourcePedestals;
    private final SulfuricFluxEmitterSelectedPoint targetPedestal;
    private final SulfuricFluxEmitterSelectedPoint resultPedestal;
    private final BlockPos blockPos;

    public MessageShowSulfuricFluxEmitterStatus(BlockPos blockPos, List<SulfuricFluxEmitterSelectedPoint> sourcePedestals, SulfuricFluxEmitterSelectedPoint targetPedestal, SulfuricFluxEmitterSelectedPoint resultPedestal) {
        this.blockPos = blockPos;
        this.sourcePedestals = sourcePedestals;
        this.targetPedestal = targetPedestal;
        this.resultPedestal = resultPedestal;
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        BlockEntity blockEntity;
        Level level = player.level();
        this.sourcePedestals.forEach(point -> point.setLevel(level));
        if (this.targetPedestal != null) {
            this.targetPedestal.setLevel(level);
        }
        if (this.resultPedestal != null) {
            this.resultPedestal.setLevel(level);
        }
        if ((blockEntity = level.getBlockEntity(this.blockPos)) instanceof SulfuricFluxEmitterBlockEntity) {
            SulfuricFluxEmitterBlockEntity sulfuricFluxEmitter = (SulfuricFluxEmitterBlockEntity)blockEntity;
            sulfuricFluxEmitter.setSelectedPointsClient(this.sourcePedestals, this.targetPedestal, this.resultPedestal);
        }
        ((SulfuricFluxEmitterBlock)((Object)BlockRegistry.SULFURIC_FLUX_EMITTER.get())).interactionBehaviour().showStatus(level, this.blockPos, player);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

